/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.impl.world.item.container;

import fuzs.easyshulkerboxes.impl.world.inventory.ContainerSlotHelper;
import fuzs.easyshulkerboxes.impl.world.inventory.ItemMoveHelper;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInteractionHelper {
    public static final String TAG_ITEMS = "Items";

    public static boolean overrideStackedOnOther(Supplier<SimpleContainer> containerSupplier, Slot slot, ClickAction clickAction, Player player, ToIntFunction<ItemStack> acceptableItemCount) {
        ItemStack stackBelowMe = slot.m_7993_();
        boolean extractSingleItemOnly = ContainerSlotHelper.extractSingleItemOnly(player);
        if (clickAction == ClickAction.SECONDARY && (stackBelowMe.m_41619_() || extractSingleItemOnly)) {
            BiConsumer<ItemStack, Integer> addToSlot = (stackToAdd, index) -> ItemInteractionHelper.addStack(containerSupplier, player, slot.m_150659_(stackToAdd), acceptableItemCount, index);
            ItemInteractionHelper.handleRemoveItem(containerSupplier, stackBelowMe, player, extractSingleItemOnly, addToSlot);
            return true;
        }
        if (clickAction == ClickAction.SECONDARY || extractSingleItemOnly) {
            ItemStack stackInSlot = slot.m_150647_(stackBelowMe.m_41613_(), stackBelowMe.m_41613_(), player);
            ItemInteractionHelper.handleAddItem(containerSupplier, clickAction, player, acceptableItemCount, stackInSlot);
            slot.m_150659_(stackInSlot);
            return true;
        }
        return false;
    }

    public static boolean overrideOtherStackedOnMe(Supplier<SimpleContainer> containerSupplier, ItemStack stackOnMe, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess, ToIntFunction<ItemStack> acceptableItemCount) {
        if (!slot.m_150651_(player)) {
            return false;
        }
        boolean extractSingleItemOnly = ContainerSlotHelper.extractSingleItemOnly(player);
        if (clickAction == ClickAction.SECONDARY && (stackOnMe.m_41619_() || extractSingleItemOnly)) {
            BiConsumer<ItemStack, Integer> addToSlot = (stackToAdd, index) -> {
                ItemStack stackInSlot = slotAccess.m_142196_();
                if (stackInSlot.m_41619_()) {
                    slotAccess.m_142104_(stackToAdd);
                } else {
                    stackInSlot.m_41769_(stackToAdd.m_41613_());
                    slotAccess.m_142104_(stackInSlot);
                }
            };
            ItemInteractionHelper.handleRemoveItem(containerSupplier, stackOnMe, player, extractSingleItemOnly, addToSlot);
            return true;
        }
        if (clickAction == ClickAction.SECONDARY || extractSingleItemOnly) {
            ItemInteractionHelper.handleAddItem(containerSupplier, clickAction, player, acceptableItemCount, stackOnMe);
            return true;
        }
        return false;
    }

    private static void handleRemoveItem(Supplier<SimpleContainer> containerSupplier, ItemStack stackOnMe, Player player, boolean extractSingleItemOnly, BiConsumer<ItemStack, Integer> addToSlot) {
        Predicate<ItemStack> itemFilter = stackInSlot -> stackOnMe.m_41619_() || ItemStack.m_150942_((ItemStack)stackOnMe, (ItemStack)stackInSlot) && stackOnMe.m_41613_() < stackOnMe.m_41741_();
        ToIntFunction<ItemStack> amountToRemove = stack -> extractSingleItemOnly ? 1 : stack.m_41613_();
        Pair<ItemStack, Integer> result = ItemInteractionHelper.removeLastStack(containerSupplier, player, itemFilter, amountToRemove);
        ItemStack stackToAdd = (ItemStack)result.getLeft();
        if (!stackToAdd.m_41619_()) {
            addToSlot.accept(stackToAdd, (Integer)result.getRight());
            player.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
        }
    }

    private static void handleAddItem(Supplier<SimpleContainer> containerSupplier, ClickAction clickAction, Player player, ToIntFunction<ItemStack> acceptableItemCount, ItemStack stackInSlot) {
        int transferredCount = clickAction == ClickAction.PRIMARY ? ItemInteractionHelper.addStack(containerSupplier, player, stackInSlot, stack -> Math.min(1, acceptableItemCount.applyAsInt((ItemStack)stack))) : ItemInteractionHelper.addStack(containerSupplier, player, stackInSlot, acceptableItemCount);
        stackInSlot.m_41774_(transferredCount);
        if (transferredCount > 0) {
            player.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
        }
    }

    private static int addStack(Supplier<SimpleContainer> containerSupplier, Player player, ItemStack newStack, ToIntFunction<ItemStack> acceptableItemCount) {
        return ItemInteractionHelper.addStack(containerSupplier, player, newStack, acceptableItemCount, ContainerSlotHelper.getCurrentContainerSlot(player));
    }

    private static int addStack(Supplier<SimpleContainer> containerSupplier, Player player, ItemStack newStack, ToIntFunction<ItemStack> acceptableItemCount, int prioritizedSlot) {
        if (newStack.m_41619_()) {
            return 0;
        }
        SimpleContainer container = containerSupplier.get();
        ItemStack stackToAdd = newStack.m_41777_();
        stackToAdd.m_41764_(Math.min(acceptableItemCount.applyAsInt(newStack), newStack.m_41613_()));
        if (stackToAdd.m_41619_()) {
            return 0;
        }
        Pair<ItemStack, Integer> result = ItemMoveHelper.addItem((Container)container, stackToAdd, prioritizedSlot);
        ContainerSlotHelper.setCurrentContainerSlot(player, (Integer)result.getRight());
        return stackToAdd.m_41613_() - ((ItemStack)result.getLeft()).m_41613_();
    }

    private static Pair<ItemStack, Integer> removeLastStack(Supplier<SimpleContainer> containerSupplier, Player player, Predicate<ItemStack> itemFilter, ToIntFunction<ItemStack> amountToRemove) {
        SimpleContainer container = containerSupplier.get();
        OptionalInt slotWithContent = ItemInteractionHelper.findSlotWithContent(container, player, itemFilter, amountToRemove);
        if (slotWithContent.isPresent()) {
            int index = slotWithContent.getAsInt();
            int amount = amountToRemove.applyAsInt(container.m_8020_(index));
            return Pair.of((Object)container.m_7407_(index, amount), (Object)index);
        }
        return Pair.of((Object)ItemStack.f_41583_, (Object)-1);
    }

    private static OptionalInt findSlotWithContent(SimpleContainer container, Player player, Predicate<ItemStack> itemFilter, ToIntFunction<ItemStack> amountToRemove) {
        ItemStack stackInSlot;
        int currentContainerSlot = ContainerSlotHelper.getCurrentContainerSlot(player);
        if (currentContainerSlot >= 0 && currentContainerSlot < container.m_6643_() && !(stackInSlot = container.m_8020_(currentContainerSlot)).m_41619_() && itemFilter.test(stackInSlot)) {
            if (stackInSlot.m_41613_() <= amountToRemove.applyAsInt(stackInSlot)) {
                ContainerSlotHelper.cycleCurrentSlotBackwards(player, container);
            }
            return OptionalInt.of(currentContainerSlot);
        }
        for (int i = container.m_6643_() - 1; i >= 0; --i) {
            ItemStack stackInSlot2 = container.m_8020_(i);
            if (stackInSlot2.m_41619_() || !itemFilter.test(stackInSlot2)) continue;
            if (stackInSlot2.m_41613_() <= amountToRemove.applyAsInt(stackInSlot2)) {
                ContainerSlotHelper.resetCurrentContainerSlot(player);
            } else {
                ContainerSlotHelper.setCurrentContainerSlot(player, i);
            }
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }
}

