/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.integration.inmis;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.easyshulkerboxes.api.container.v1.ContainerItemHelper;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.SimpleItemProvider;
import fuzs.easyshulkerboxes.integration.inmis.SimpleInmisContainer;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class InmisProvider
extends SimpleItemProvider {
    public InmisProvider(int inventoryWidth, int inventoryHeight, @Nullable DyeColor dyeColor, String ... nbtKey) {
        super(inventoryWidth, inventoryHeight, dyeColor, nbtKey);
    }

    @Override
    public SimpleContainer getItemContainer(ItemStack containerStack, Player player, boolean allowSaving) {
        return ContainerItemHelper.INSTANCE.loadItemContainer(containerStack, (ItemContainerProvider)this, items -> new SimpleInmisContainer(this.getInventorySize()), allowSaving, this.getNbtKey());
    }

    public static ItemContainerProvider fromJson(JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        int inventoryWidth = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"inventory_width");
        int inventoryHeight = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"inventory_height");
        DyeColor dyeColor = DyeColor.m_41057_((String)GsonHelper.m_13851_((JsonObject)jsonObject, (String)"background_color", (String)""), null);
        String[] nbtKey = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"nbt_key", (String)"Items").split("/");
        boolean filterContainerItems = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"filter_container_items", (boolean)false);
        JsonArray disallowedItemsData = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"disallowed_items", (JsonArray)new JsonArray());
        List<String> disallowedItems = StreamSupport.stream(disallowedItemsData.spliterator(), false).map(JsonElement::getAsString).toList();
        InmisProvider provider = new InmisProvider(inventoryWidth, inventoryHeight, dyeColor, nbtKey);
        if (filterContainerItems) {
            provider.filterContainerItems();
        }
        provider.disallowValues(disallowedItems);
        return provider;
    }
}

