/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.tooltip;

import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Matrix4f;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public class TooltipDecor {
    public static final ResourceLocation DEFAULT_BORDERS = new ResourceLocation("legendarytooltips", "textures/gui/tooltip_borders.png");
    static int currentTooltipBorderStart = 0;
    static int currentTooltipBorderEnd = 0;
    static int currentTooltipBackgroundStart = 0;
    static int currentTooltipBackgroundEnd = 0;
    private static float shineTimer = 2.5f;
    private static Map<Integer, List<Either<FormattedText, TooltipComponent>>> cachedPreWrapLines = new HashMap<Integer, List<Either<FormattedText, TooltipComponent>>>();

    public static void setCurrentTooltipBorderStart(int color) {
        currentTooltipBorderStart = color;
    }

    public static void setCurrentTooltipBorderEnd(int color) {
        currentTooltipBorderEnd = color;
    }

    public static void setCurrentTooltipBackgroundStart(int color) {
        currentTooltipBackgroundStart = color;
    }

    public static void setCurrentTooltipBackgroundEnd(int color) {
        currentTooltipBackgroundEnd = color;
    }

    public static void setCachedLines(List<Either<FormattedText, TooltipComponent>> lines, int index) {
        cachedPreWrapLines.put(index, lines);
    }

    public static void updateTimer(float deltaTime) {
        if (shineTimer > 0.0f) {
            shineTimer -= deltaTime;
        }
    }

    public static void resetTimer() {
        shineTimer = 2.5f;
    }

    public static void drawShadow(PoseStack poseStack, int x, int y, int width, int height) {
        int shadowColor = 0x44000000;
        poseStack.m_85836_();
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x - 1), (int)(y + height + 4), (int)(x + width + 4), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x + width + 4), (int)(y - 1), (int)(x + width + 5), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x + width + 3), (int)(y + height + 3), (int)(x + width + 4), (int)(y + height + 4), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)x, (int)(y + height + 5), (int)(x + width + 5), (int)(y + height + 6), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x + width + 5), (int)y, (int)(x + width + 6), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        poseStack.m_85849_();
    }

    public static void drawSeparator(PoseStack poseStack, int x, int y, int width, int color) {
        poseStack.m_85836_();
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)402, (int)x, (int)y, (int)(x + width / 2), (int)(y + 1), (int)(color & 0xFFFFFF), (int)color);
        GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)402, (int)(x + width / 2), (int)y, (int)(x + width), (int)(y + 1), (int)color, (int)(color & 0xFFFFFF));
        poseStack.m_85849_();
    }

    public static void drawBorder(PoseStack poseStack, int x, int y, int width, int height, ItemStack item, List<ClientTooltipComponent> components, Font font, LegendaryTooltipsConfig.FrameDefinition frameDefinition, boolean comparison, int index) {
        Matrix4f matrix;
        if (comparison) {
            poseStack.m_85836_();
            matrix = poseStack.m_85850_().m_85861_();
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x - 3), (int)(y - 3 + 1), (int)(x - 3 + 1), (int)(y + height + 3 - 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderEnd);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x + width + 2), (int)(y - 3 + 1), (int)(x + width + 3), (int)(y + height + 3 - 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderEnd);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y - 3 + 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderStart);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x - 3), (int)(y + height + 2), (int)(x + width + 3), (int)(y + height + 3), (int)currentTooltipBorderEnd, (int)currentTooltipBorderEnd);
            poseStack.m_85849_();
            TooltipDecor.drawSeparator(poseStack, x - 3 + 1, y - 3 + 1 + 10, width, currentTooltipBorderStart);
        }
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.nameSeparator.get()).booleanValue() && item != null && !item.m_41619_() && frameDefinition.index() != -2) {
            int titleLines = Tooltips.calculateTitleLines(components);
            int numComponents = components.size() - 1;
            if (LegendaryTooltipsConfig.showModelForItem(item)) {
                --titleLines;
                numComponents -= 2;
            }
            if (titleLines < numComponents) {
                int i;
                int offset = 0;
                int titleStart = 0;
                if (LegendaryTooltipsConfig.showModelForItem(item)) {
                    offset += 7;
                }
                for (i = 0; i < components.size(); ++i) {
                    if (!(components.get(i) instanceof ClientTextTooltip)) continue;
                    titleStart = i;
                    break;
                }
                for (i = 0; i < titleStart + titleLines && i < components.size(); ++i) {
                    ClientTooltipComponent component = components.get(i);
                    if (component instanceof ClientTextTooltip) {
                        int n = component.m_142103_();
                        Objects.requireNonNull(font);
                        offset += Math.max(n, 9);
                        continue;
                    }
                    offset += component.m_142103_();
                    if (i > titleStart) continue;
                    offset += 2;
                }
                if (comparison) {
                    offset += 11;
                }
                TooltipDecor.drawSeparator(poseStack, x - 3 + 1, y - 3 + 2 + offset, width, currentTooltipBorderStart);
            }
        }
        if (frameDefinition.index() == -1) {
            return;
        }
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.shineEffect.get()).booleanValue()) {
            int alpha;
            poseStack.m_85836_();
            matrix = poseStack.m_85850_().m_85861_();
            if (shineTimer >= 0.5f && shineTimer <= 2.0f) {
                float interval = Mth.m_14036_((float)(shineTimer - 0.5f), (float)0.0f, (float)1.0f);
                alpha = (int)(153.0f * interval) << 24;
                int horizontalMin = x - 3;
                int horizontalMax = x + width + 3;
                int horizontalInterval = (int)Mth.m_14179_((float)(interval * interval), (float)horizontalMax, (float)horizontalMin);
                GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)402, (int)Math.max(horizontalInterval - 36, horizontalMin), (int)(y - 3), (int)Math.min(horizontalInterval, horizontalMax), (int)(y - 3 + 1), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)402, (int)Math.max(horizontalInterval, horizontalMin), (int)(y - 3), (int)Math.min(horizontalInterval + 36, horizontalMax), (int)(y - 3 + 1), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
            }
            if (shineTimer <= 1.0f) {
                float interval = Mth.m_14036_((float)shineTimer, (float)0.0f, (float)1.0f);
                alpha = (int)(85.0f * interval) << 24;
                int verticalMin = y - 3 + 1;
                int verticalMax = y + height + 3 - 1;
                int verticalInterval = (int)Mth.m_14179_((float)(interval * interval), (float)verticalMax, (float)verticalMin);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)402, (int)(x - 3), (int)Math.max(verticalInterval - 12, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval, verticalMax), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)402, (int)(x - 3), (int)Math.max(verticalInterval, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval + 12, verticalMax), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
            }
            poseStack.m_85849_();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)frameDefinition.resource());
        Minecraft minecraft = Minecraft.m_91087_();
        AbstractTexture borderTexture = minecraft.m_91097_().m_118506_(frameDefinition.resource());
        borderTexture.m_117966_();
        int textureWidth = GlStateManager.m_84384_((int)3553, (int)0, (int)4096);
        int textureHeight = GlStateManager.m_84384_((int)3553, (int)0, (int)4097);
        int frameIndex = frameDefinition.index();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 410.0);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x - 6), (int)(y - 6), (float)(frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width - 8 + 6), (int)(y - 6), (float)(56 + frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x - 6), (int)(y + height - 8 + 6), (float)(frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight + 8), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width - 8 + 6), (int)(y + height - 8 + 6), (float)(56 + frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight + 8), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        if (width >= 48) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width / 2 - 24), (int)(y - 9), (float)(8 + frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight), (int)48, (int)8, (int)textureWidth, (int)textureHeight);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width / 2 - 24), (int)(y + height - 8 + 9), (float)(8 + frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight + 8), (int)48, (int)8, (int)textureWidth, (int)textureHeight);
        }
        poseStack.m_85849_();
    }
}

