/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.utils;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.grapplemod;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;

public class GrappleCustomization {
    public static final String[] booleanoptions = new String[]{"phaserope", "motor", "motorwhencrouching", "motorwhennotcrouching", "smartmotor", "enderstaff", "repel", "attract", "doublehook", "smartdoublemotor", "motordampener", "reelin", "pullbackwards", "oneropepull", "sticky", "detachonkeyrelease", "rocket"};
    public static final String[] doubleoptions = new String[]{"maxlen", "hookgravity", "throwspeed", "motormaxspeed", "motoracceleration", "playermovementmult", "repelforce", "attractradius", "angle", "sneakingangle", "verticalthrowangle", "sneakingverticalthrowangle", "rocket_force", "rocket_active_time", "rocket_refuel_ratio", "rocket_vertical_angle"};
    public double maxlen;
    public boolean phaserope;
    public boolean sticky;
    public double hookgravity;
    public double throwspeed;
    public boolean reelin;
    public double verticalthrowangle;
    public double sneakingverticalthrowangle;
    public boolean detachonkeyrelease;
    public boolean motor;
    public double motormaxspeed;
    public double motoracceleration;
    public boolean motorwhencrouching;
    public boolean motorwhennotcrouching;
    public boolean smartmotor;
    public boolean motordampener;
    public boolean pullbackwards;
    public double playermovementmult;
    public boolean enderstaff;
    public boolean repel;
    public double repelforce;
    public boolean attract;
    public double attractradius;
    public boolean doublehook;
    public boolean smartdoublemotor;
    public double angle;
    public double sneakingangle;
    public boolean oneropepull;
    public boolean rocket;
    public double rocket_force;
    public double rocket_active_time;
    public double rocket_refuel_ratio;
    public double rocket_vertical_angle;
    public static GrappleCustomization DEFAULT = new GrappleCustomization();

    public GrappleCustomization() {
        this.setDefaults();
    }

    public void setDefaults() {
        Object optionconfig;
        for (String option : booleanoptions) {
            optionconfig = this.getBooleanConfig(option);
            this.setBoolean(option, ((GrappleConfig.Config.GrapplingHook.Custom.BooleanCustomizationOption)optionconfig).default_value);
        }
        for (String option : doubleoptions) {
            optionconfig = this.getDoubleConfig(option);
            this.setDouble(option, ((GrappleConfig.Config.GrapplingHook.Custom.DoubleCustomizationOption)optionconfig).default_value);
        }
    }

    public GrappleConfig.Config.GrapplingHook.Custom.BooleanCustomizationOption getBooleanConfig(String option) {
        if (option.equals("phaserope")) {
            return GrappleConfig.getConf().grapplinghook.custom.rope.phaserope;
        }
        if (option.equals("motor")) {
            return GrappleConfig.getConf().grapplinghook.custom.motor.motor;
        }
        if (option.equals("motorwhencrouching")) {
            return GrappleConfig.getConf().grapplinghook.custom.motor.motorwhencrouching;
        }
        if (option.equals("motorwhennotcrouching")) {
            return GrappleConfig.getConf().grapplinghook.custom.motor.motorwhennotcrouching;
        }
        if (option.equals("smartmotor")) {
            return GrappleConfig.getConf().grapplinghook.custom.motor.smartmotor;
        }
        if (option.equals("enderstaff")) {
            return GrappleConfig.getConf().grapplinghook.custom.enderstaff.enderstaff;
        }
        if (option.equals("repel")) {
            return GrappleConfig.getConf().grapplinghook.custom.forcefield.repel;
        }
        if (option.equals("attract")) {
            return GrappleConfig.getConf().grapplinghook.custom.magnet.attract;
        }
        if (option.equals("doublehook")) {
            return GrappleConfig.getConf().grapplinghook.custom.doublehook.doublehook;
        }
        if (option.equals("smartdoublemotor")) {
            return GrappleConfig.getConf().grapplinghook.custom.doublehook.smartdoublemotor;
        }
        if (option.equals("motordampener")) {
            return GrappleConfig.getConf().grapplinghook.custom.motor.motordampener;
        }
        if (option.equals("reelin")) {
            return GrappleConfig.getConf().grapplinghook.custom.hookthrower.reelin;
        }
        if (option.equals("pullbackwards")) {
            return GrappleConfig.getConf().grapplinghook.custom.motor.pullbackwards;
        }
        if (option.equals("oneropepull")) {
            return GrappleConfig.getConf().grapplinghook.custom.doublehook.oneropepull;
        }
        if (option.equals("sticky")) {
            return GrappleConfig.getConf().grapplinghook.custom.rope.sticky;
        }
        if (option.equals("detachonkeyrelease")) {
            return GrappleConfig.getConf().grapplinghook.custom.hookthrower.detachonkeyrelease;
        }
        if (option.equals("rocket")) {
            return GrappleConfig.getConf().grapplinghook.custom.rocket.rocketenabled;
        }
        return null;
    }

    public GrappleConfig.Config.GrapplingHook.Custom.DoubleCustomizationOption getDoubleConfig(String option) {
        if (option.equals("maxlen")) {
            return GrappleConfig.getConf().grapplinghook.custom.rope.maxlen;
        }
        if (option.equals("hookgravity")) {
            return GrappleConfig.getConf().grapplinghook.custom.hookthrower.hookgravity;
        }
        if (option.equals("throwspeed")) {
            return GrappleConfig.getConf().grapplinghook.custom.hookthrower.throwspeed;
        }
        if (option.equals("motormaxspeed")) {
            return GrappleConfig.getConf().grapplinghook.custom.motor.motormaxspeed;
        }
        if (option.equals("motoracceleration")) {
            return GrappleConfig.getConf().grapplinghook.custom.motor.motoracceleration;
        }
        if (option.equals("playermovementmult")) {
            return GrappleConfig.getConf().grapplinghook.custom.swing.playermovementmult;
        }
        if (option.equals("repelforce")) {
            return GrappleConfig.getConf().grapplinghook.custom.forcefield.repelforce;
        }
        if (option.equals("attractradius")) {
            return GrappleConfig.getConf().grapplinghook.custom.magnet.attractradius;
        }
        if (option.equals("angle")) {
            return GrappleConfig.getConf().grapplinghook.custom.doublehook.angle;
        }
        if (option.equals("sneakingangle")) {
            return GrappleConfig.getConf().grapplinghook.custom.doublehook.sneakingangle;
        }
        if (option.equals("verticalthrowangle")) {
            return GrappleConfig.getConf().grapplinghook.custom.hookthrower.verticalthrowangle;
        }
        if (option.equals("sneakingverticalthrowangle")) {
            return GrappleConfig.getConf().grapplinghook.custom.hookthrower.sneakingverticalthrowangle;
        }
        if (option.equals("rocket_force")) {
            return GrappleConfig.getConf().grapplinghook.custom.rocket.rocket_force;
        }
        if (option.equals("rocket_active_time")) {
            return GrappleConfig.getConf().grapplinghook.custom.rocket.rocket_active_time;
        }
        if (option.equals("rocket_refuel_ratio")) {
            return GrappleConfig.getConf().grapplinghook.custom.rocket.rocket_refuel_ratio;
        }
        if (option.equals("rocket_vertical_angle")) {
            return GrappleConfig.getConf().grapplinghook.custom.rocket.rocket_vertical_angle;
        }
        return null;
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        for (String option : booleanoptions) {
            compound.m_128379_(option, this.getBoolean(option));
        }
        for (String option : doubleoptions) {
            compound.m_128347_(option, this.getDouble(option));
        }
        compound.m_128356_("crc32", this.getChecksum());
        return compound;
    }

    public void loadNBT(CompoundTag compound) {
        for (String option : booleanoptions) {
            if (!compound.m_128441_(option)) continue;
            this.setBoolean(option, compound.m_128471_(option));
        }
        for (String option : doubleoptions) {
            if (!compound.m_128441_(option)) continue;
            this.setDouble(option, compound.m_128459_(option));
        }
        if (compound.m_128441_("crc32")) {
            long recordedChecksum = compound.m_128454_("crc32");
            if (this.getChecksum() != recordedChecksum) {
                grapplemod.LOGGER.error("Error checksum reading from NBT");
                this.setDefaults();
            }
        }
    }

    public void setBoolean(String option, boolean bool) {
        if (option.equals("phaserope")) {
            this.phaserope = bool;
        } else if (option.equals("motor")) {
            this.motor = bool;
        } else if (option.equals("motorwhencrouching")) {
            this.motorwhencrouching = bool;
        } else if (option.equals("motorwhennotcrouching")) {
            this.motorwhennotcrouching = bool;
        } else if (option.equals("smartmotor")) {
            this.smartmotor = bool;
        } else if (option.equals("enderstaff")) {
            this.enderstaff = bool;
        } else if (option.equals("repel")) {
            this.repel = bool;
        } else if (option.equals("attract")) {
            this.attract = bool;
        } else if (option.equals("doublehook")) {
            this.doublehook = bool;
        } else if (option.equals("smartdoublemotor")) {
            this.smartdoublemotor = bool;
        } else if (option.equals("motordampener")) {
            this.motordampener = bool;
        } else if (option.equals("reelin")) {
            this.reelin = bool;
        } else if (option.equals("pullbackwards")) {
            this.pullbackwards = bool;
        } else if (option.equals("oneropepull")) {
            this.oneropepull = bool;
        } else if (option.equals("sticky")) {
            this.sticky = bool;
        } else if (option.equals("detachonkeyrelease")) {
            this.detachonkeyrelease = bool;
        } else if (option.equals("rocket")) {
            this.rocket = bool;
        } else {
            System.out.println("Option doesn't exist: " + option);
        }
    }

    public boolean getBoolean(String option) {
        if (option.equals("phaserope")) {
            return this.phaserope;
        }
        if (option.equals("motor")) {
            return this.motor;
        }
        if (option.equals("motorwhencrouching")) {
            return this.motorwhencrouching;
        }
        if (option.equals("motorwhennotcrouching")) {
            return this.motorwhennotcrouching;
        }
        if (option.equals("smartmotor")) {
            return this.smartmotor;
        }
        if (option.equals("enderstaff")) {
            return this.enderstaff;
        }
        if (option.equals("repel")) {
            return this.repel;
        }
        if (option.equals("attract")) {
            return this.attract;
        }
        if (option.equals("doublehook")) {
            return this.doublehook;
        }
        if (option.equals("smartdoublemotor")) {
            return this.smartdoublemotor;
        }
        if (option.equals("motordampener")) {
            return this.motordampener;
        }
        if (option.equals("reelin")) {
            return this.reelin;
        }
        if (option.equals("pullbackwards")) {
            return this.pullbackwards;
        }
        if (option.equals("oneropepull")) {
            return this.oneropepull;
        }
        if (option.equals("sticky")) {
            return this.sticky;
        }
        if (option.equals("detachonkeyrelease")) {
            return this.detachonkeyrelease;
        }
        if (option.equals("rocket")) {
            return this.rocket;
        }
        System.out.println("Option doesn't exist: " + option);
        return false;
    }

    public void setDouble(String option, double d) {
        if (option.equals("maxlen")) {
            this.maxlen = d;
        } else if (option.equals("hookgravity")) {
            this.hookgravity = d;
        } else if (option.equals("throwspeed")) {
            this.throwspeed = d;
        } else if (option.equals("motormaxspeed")) {
            this.motormaxspeed = d;
        } else if (option.equals("motoracceleration")) {
            this.motoracceleration = d;
        } else if (option.equals("playermovementmult")) {
            this.playermovementmult = d;
        } else if (option.equals("repelforce")) {
            this.repelforce = d;
        } else if (option.equals("attractradius")) {
            this.attractradius = d;
        } else if (option.equals("angle")) {
            this.angle = d;
        } else if (option.equals("sneakingangle")) {
            this.sneakingangle = d;
        } else if (option.equals("verticalthrowangle")) {
            this.verticalthrowangle = d;
        } else if (option.equals("sneakingverticalthrowangle")) {
            this.sneakingverticalthrowangle = d;
        } else if (option.equals("rocket_force")) {
            this.rocket_force = d;
        } else if (option.equals("rocket_active_time")) {
            this.rocket_active_time = d;
        } else if (option.equals("rocket_refuel_ratio")) {
            this.rocket_refuel_ratio = d;
        } else if (option.equals("rocket_vertical_angle")) {
            this.rocket_vertical_angle = d;
        } else {
            System.out.println("Option doesn't exist: " + option);
        }
    }

    public double getDouble(String option) {
        if (option.equals("maxlen")) {
            return this.maxlen;
        }
        if (option.equals("hookgravity")) {
            return this.hookgravity;
        }
        if (option.equals("throwspeed")) {
            return this.throwspeed;
        }
        if (option.equals("motormaxspeed")) {
            return this.motormaxspeed;
        }
        if (option.equals("motoracceleration")) {
            return this.motoracceleration;
        }
        if (option.equals("playermovementmult")) {
            return this.playermovementmult;
        }
        if (option.equals("repelforce")) {
            return this.repelforce;
        }
        if (option.equals("attractradius")) {
            return this.attractradius;
        }
        if (option.equals("angle")) {
            return this.angle;
        }
        if (option.equals("sneakingangle")) {
            return this.sneakingangle;
        }
        if (option.equals("verticalthrowangle")) {
            return this.verticalthrowangle;
        }
        if (option.equals("sneakingverticalthrowangle")) {
            return this.sneakingverticalthrowangle;
        }
        if (option.equals("rocket_force")) {
            return this.rocket_force;
        }
        if (option.equals("rocket_active_time")) {
            return this.rocket_active_time;
        }
        if (option.equals("rocket_refuel_ratio")) {
            return this.rocket_refuel_ratio;
        }
        if (option.equals("rocket_vertical_angle")) {
            return this.rocket_vertical_angle;
        }
        System.out.println("Option doesn't exist: " + option);
        return 0.0;
    }

    public long getChecksum() {
        CRC32 checker = new CRC32();
        for (String option : booleanoptions) {
            checker.update(this.getBoolean(option) ? 1 : 0);
        }
        for (String option : doubleoptions) {
            checker.update(ByteBuffer.allocate(8).putDouble(this.getDouble(option)).array());
        }
        checker.update(54902349);
        return checker.getValue();
    }

    public void writeToBuf(ByteBuf buf) {
        for (String option : booleanoptions) {
            buf.writeBoolean(this.getBoolean(option));
        }
        for (String option : doubleoptions) {
            buf.writeDouble(this.getDouble(option));
        }
        buf.writeLong(this.getChecksum());
    }

    public void readFromBuf(ByteBuf buf) {
        for (String option : booleanoptions) {
            this.setBoolean(option, buf.readBoolean());
        }
        for (String option : doubleoptions) {
            this.setDouble(option, buf.readDouble());
        }
        long recordedChecksum = buf.readLong();
        if (this.getChecksum() != recordedChecksum) {
            grapplemod.LOGGER.error("Error checksum reading from buffer");
            this.setDefaults();
        }
    }

    public String getName(String option) {
        return "grapplecustomization." + option;
    }

    public String getDescription(String option) {
        return "grapplecustomization." + option + ".desc";
    }

    public boolean isOptionValid(String option) {
        if (option == "motormaxspeed" || option == "motoracceleration" || option == "motorwhencrouching" || option == "motorwhennotcrouching" || option == "smartmotor" || option == "motordampener" || option == "pullbackwards") {
            return this.motor;
        }
        if (option == "sticky") {
            return !this.phaserope;
        }
        if (option == "sneakingangle") {
            return this.doublehook && !this.reelin;
        }
        if (option == "repelforce") {
            return this.repel;
        }
        if (option == "attractradius") {
            return this.attract;
        }
        if (option == "angle") {
            return this.doublehook;
        }
        if (option == "smartdoublemotor" || option == "oneropepull") {
            return this.doublehook && this.motor;
        }
        if (option == "rocket_active_time" || option == "rocket_refuel_ratio" || option == "rocket_force" || option == "rocket_vertical_angle") {
            return this.rocket;
        }
        return true;
    }

    public double getMax(String option, int upgrade) {
        GrappleConfig.Config.GrapplingHook.Custom.DoubleCustomizationOption configoption = this.getDoubleConfig(option);
        return upgrade == 1 ? configoption.max_upgraded : configoption.max;
    }

    public double getMin(String option, int upgrade) {
        GrappleConfig.Config.GrapplingHook.Custom.DoubleCustomizationOption configoption = this.getDoubleConfig(option);
        return upgrade == 1 ? configoption.min_upgraded : configoption.min;
    }

    public int optionEnabled(String option) {
        GrappleConfig.Config.GrapplingHook.Custom.BooleanCustomizationOption configoption = this.getBooleanConfig(option);
        if (configoption != null) {
            return configoption.enabled;
        }
        return this.getDoubleConfig((String)option).enabled;
    }

    public boolean equals(GrappleCustomization other) {
        for (String option : booleanoptions) {
            if (this.getBoolean(option) == other.getBoolean(option)) continue;
            return false;
        }
        for (String option : doubleoptions) {
            if (this.getDouble(option) == other.getDouble(option)) continue;
            return false;
        }
        return true;
    }

    public static enum upgradeCategories {
        ROPE("rope"),
        THROW("throw"),
        MOTOR("motor"),
        SWING("swing"),
        STAFF("staff"),
        FORCEFIELD("forcefield"),
        MAGNET("magnet"),
        DOUBLE("double"),
        LIMITS("limits"),
        ROCKET("rocket");

        private String nameUnlocalized;

        private upgradeCategories(String name) {
            this.nameUnlocalized = name;
        }

        public String getName() {
            if (ClientProxyInterface.proxy != null) {
                return ClientProxyInterface.proxy.localize("grapplemod.upgradecategories." + this.nameUnlocalized);
            }
            return this.nameUnlocalized;
        }

        public static upgradeCategories fromInt(int i) {
            return upgradeCategories.values()[i];
        }

        public int toInt() {
            for (int i = 0; i < upgradeCategories.size(); ++i) {
                if (upgradeCategories.values()[i] != this) continue;
                return i;
            }
            return -1;
        }

        public static int size() {
            return upgradeCategories.values().length;
        }

        public Item getItem() {
            if (this == ROPE) {
                return (Item)CommonSetup.ropeUpgradeItem.get();
            }
            if (this == THROW) {
                return (Item)CommonSetup.throwUpgradeItem.get();
            }
            if (this == MOTOR) {
                return (Item)CommonSetup.motorUpgradeItem.get();
            }
            if (this == SWING) {
                return (Item)CommonSetup.swingUpgradeItem.get();
            }
            if (this == STAFF) {
                return (Item)CommonSetup.staffUpgradeItem.get();
            }
            if (this == FORCEFIELD) {
                return (Item)CommonSetup.forcefieldUpgradeItem.get();
            }
            if (this == MAGNET) {
                return (Item)CommonSetup.magnetUpgradeItem.get();
            }
            if (this == DOUBLE) {
                return (Item)CommonSetup.doubleUpgradeItem.get();
            }
            if (this == LIMITS) {
                return (Item)CommonSetup.limitsUpgradeItem.get();
            }
            if (this == ROCKET) {
                return (Item)CommonSetup.rocketUpgradeItem.get();
            }
            return null;
        }
    }
}

