/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.networking.v3;

import fuzs.puzzleslib.api.networking.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.api.networking.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.core.CommonFactories;
import fuzs.puzzleslib.proxy.Proxy;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface NetworkHandlerV3 {
    public <T extends Record> Packet<?> toClientboundPacket(T var1);

    public <T extends Record> Packet<?> toServerboundPacket(T var1);

    default public <T extends Record> void sendToServer(T message) {
        Proxy.INSTANCE.getClientConnection().m_129512_(this.toServerboundPacket(message));
    }

    default public <T extends Record> void sendTo(T message, ServerPlayer player) {
        player.f_8906_.m_9829_(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAll(T message) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11268_(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllExcept(T message, ServerPlayer exclude) {
        for (ServerPlayer player : Proxy.INSTANCE.getGameServer().m_6846_().m_11314_()) {
            if (player == exclude) continue;
            this.sendTo(message, player);
        }
    }

    default public <T extends Record> void sendToAllNear(T message, BlockPos pos, Level level) {
        this.sendToAllNearExcept(message, null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 64.0, level);
    }

    default public <T extends Record> void sendToAllNear(T message, double posX, double posY, double posZ, double distance, Level level) {
        this.sendToAllNearExcept(message, null, posX, posY, posZ, 64.0, level);
    }

    default public <T extends Record> void sendToAllNearExcept(T message, @Nullable ServerPlayer exclude, double posX, double posY, double posZ, double distance, Level level) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11241_((Player)exclude, posX, posY, posZ, distance, level.m_46472_(), this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTracking(T message, Entity entity) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8445_(entity, this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTrackingAndSelf(T message, Entity entity) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8394_(entity, this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToDimension(T message, Level level) {
        this.sendToDimension(message, (ResourceKey<Level>)level.m_46472_());
    }

    default public <T extends Record> void sendToDimension(T message, ResourceKey<Level> dimension) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11270_(this.toClientboundPacket(message), dimension);
    }

    public static Builder builder(String modId) {
        return CommonFactories.INSTANCE.networkingV3(modId);
    }

    public static interface Builder {
        default public <T> Builder registerSerializer(Class<T> type, FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader) {
            MessageSerializers.registerSerializer(type, writer, reader);
            return this;
        }

        default public <T> Builder registerSerializer(Class<? super T> type, ResourceKey<Registry<T>> resourceKey) {
            MessageSerializers.registerSerializer(type, resourceKey);
            return this;
        }

        default public <T> Builder registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
            MessageSerializers.registerContainerProvider(type, factory);
            return this;
        }

        public <T extends Record> Builder registerClientbound(Class<T> var1);

        public <T extends Record> Builder registerServerbound(Class<T> var1);

        public Builder clientAcceptsVanillaOrMissing();

        public Builder serverAcceptsVanillaOrMissing();

        default public Builder allAcceptVanillaOrMissing() {
            return this.clientAcceptsVanillaOrMissing().serverAcceptsVanillaOrMissing();
        }

        public NetworkHandlerV3 build();
    }
}

