/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.networking;

import fuzs.puzzleslib.api.networking.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.networking.NetworkHandlerRegistry;
import fuzs.puzzleslib.proxy.ForgeProxy;
import fuzs.puzzleslib.proxy.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandlerForge
implements NetworkHandlerRegistry {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private final SimpleChannel channel;
    private final AtomicInteger discriminator = new AtomicInteger();

    private NetworkHandlerForge(SimpleChannel channel) {
        this.channel = channel;
    }

    @Override
    public <T extends Record> void registerClientbound(Class<?> clazz) {
        this.register(clazz, (arg_0, arg_1) -> NetworkHandlerForge.lambda$registerClientbound$0((ForgeProxy)Proxy.INSTANCE, arg_0, arg_1));
    }

    @Override
    public <T extends Record> void registerServerbound(Class<?> clazz) {
        this.register(clazz, (arg_0, arg_1) -> NetworkHandlerForge.lambda$registerServerbound$1((ForgeProxy)Proxy.INSTANCE, arg_0, arg_1));
    }

    private <T> void register(Class<T> clazz, BiConsumer<T, Supplier<NetworkEvent.Context>> handle) {
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException("Message of type %s is not a record".formatted(clazz));
        }
        BiConsumer<Object, FriendlyByteBuf> encode = (t, friendlyByteBuf) -> MessageSerializers.findByType(clazz).write((FriendlyByteBuf)friendlyByteBuf, t);
        Function<FriendlyByteBuf, Object> decode = MessageSerializers.findByType(clazz)::read;
        this.channel.registerMessage(this.discriminator.getAndIncrement(), clazz, encode, decode, handle);
    }

    @Override
    public <T extends Record> Packet<?> toClientboundPacket(T message) {
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <T extends Record> Packet<?> toServerboundPacket(T message) {
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_SERVER);
    }

    private static /* synthetic */ void lambda$registerServerbound$1(ForgeProxy rec$, Object x$0, Supplier x$1) {
        rec$.registerServerReceiverV2((Record)x$0, x$1);
    }

    private static /* synthetic */ void lambda$registerClientbound$0(ForgeProxy rec$, Object x$0, Supplier x$1) {
        rec$.registerClientReceiverV2((Record)x$0, x$1);
    }

    public static class ForgeBuilderImpl
    extends NetworkHandlerRegistry.BuilderImpl {
        public ForgeBuilderImpl(String modId) {
            super(modId);
        }

        @Override
        protected NetworkHandlerRegistry getHandler() {
            return new NetworkHandlerForge(ForgeBuilderImpl.buildSimpleChannel(this.modId, this.clientAcceptsVanillaOrMissing, this.serverAcceptsVanillaOrMissing));
        }

        private static SimpleChannel buildSimpleChannel(String modId, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
            return NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modId, "play")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions((Predicate)(clientAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).serverAcceptedVersions((Predicate)(serverAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).simpleChannel();
        }
    }
}

