/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.init;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface RegistryReference<T> {
    public ResourceKey<? extends Registry<? super T>> getRegistryKey();

    public ResourceKey<T> getResourceKey();

    public ResourceLocation getResourceLocation();

    public T get();

    public Holder<T> holder();

    public boolean isPresent();

    default public boolean isEmpty() {
        return !this.isPresent();
    }

    public static <T> RegistryReference<T> placeholder(ResourceKey<? extends Registry<? super T>> registryKey, String namespace, String path) {
        return RegistryReference.placeholder(registryKey, new ResourceLocation(namespace, path));
    }

    public static <T> RegistryReference<T> placeholder(final ResourceKey<? extends Registry<? super T>> registryKey, final ResourceLocation resourceLocation) {
        final Registry registry = (Registry)Registry.f_122897_.m_7745_(registryKey.m_135782_());
        if (registry == null) {
            throw new IllegalStateException(String.format("Unable to retrieve registry from key %s", registryKey));
        }
        final ResourceKey resourceKey = ResourceKey.m_135785_(registryKey, (ResourceLocation)resourceLocation);
        return new RegistryReference<T>(){
            @Nullable
            private T value;

            @Override
            public ResourceKey<? extends Registry<? super T>> getRegistryKey() {
                return registryKey;
            }

            @Override
            public ResourceKey<T> getResourceKey() {
                return resourceKey;
            }

            @Override
            public ResourceLocation getResourceLocation() {
                return resourceLocation;
            }

            @Override
            public T get() {
                if (this.value == null) {
                    if (!registry.m_7804_(resourceLocation)) {
                        throw new IllegalStateException(String.format("Unable to retrieve placeholder %s from registry %s", resourceLocation, registryKey));
                    }
                    this.value = registry.m_7745_(resourceLocation);
                }
                return this.value;
            }

            @Override
            public Holder<T> holder() {
                return registry.m_214121_(this.getResourceKey());
            }

            @Override
            public boolean isPresent() {
                return this.value != null || registry.m_7804_(resourceLocation);
            }
        };
    }
}

