/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TypesafeMap;
import gg.essential.loader.stage2.ActualEssentialLoader;
import gg.essential.loader.stage2.SelfRenamingJarMetadata;
import gg.essential.loader.stage2.modlauncher.CompatibilityLayer;
import gg.essential.loader.stage2.modlauncher.EssentialModLocator;
import gg.essential.loader.stage2.util.KFFMerger;
import gg.essential.loader.stage2.util.SortedJarOrPathList;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModValidator;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class EssentialTransformationService
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger(EssentialTransformationService.class);
    private static final Map<String, String> COMPATIBILITY_IMPLEMENTATIONS = Map.of("9.", "ML9CompatibilityLayer", "10.", "ML10CompatibilityLayer");
    private static CompatibilityLayer compatibilityLayer;
    private final Path gameDir;
    private final List<SecureJar> pluginJars = new ArrayList<SecureJar>();
    private final List<SecureJar> gameJars = new ArrayList<SecureJar>();
    private final KFFMerger kffMerger = new KFFMerger();
    private EssentialModLocator modLocator;
    private boolean modsInjected;

    public EssentialTransformationService(Path gameDir) {
        this.gameDir = gameDir;
    }

    public void addToClasspath(Path path) {
        SecureJar jar = SecureJar.from(j -> new SelfRenamingJarMetadata((SecureJar)j, path, EssentialTransformationService.determineLayer(j)), (Path[])new Path[]{path});
        if (this.kffMerger.addKotlinJar(path, jar)) {
            return;
        }
        if (EssentialTransformationService.determineLayer(jar) == IModuleLayerManager.Layer.PLUGIN) {
            this.pluginJars.add(jar);
        } else {
            this.gameJars.add(jar);
        }
    }

    private static IModuleLayerManager.Layer determineLayer(SecureJar jar) {
        String modType = compatibilityLayer.getManifest(jar).getMainAttributes().getValue("FMLModType");
        if (IModFile.Type.LANGPROVIDER.name().equals(modType) || IModFile.Type.LIBRARY.name().equals(modType)) {
            return IModuleLayerManager.Layer.PLUGIN;
        }
        return IModuleLayerManager.Layer.GAME;
    }

    @NotNull
    public String name() {
        return "essential-loader";
    }

    public void initialize(IEnvironment environment) {
        String modLauncherVersion = (String)environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.MLIMPL_VERSION.get()).orElseThrow();
        compatibilityLayer = this.findCompatibilityLayerImpl(modLauncherVersion);
        this.modLocator = compatibilityLayer.makeModLocator();
    }

    private CompatibilityLayer findCompatibilityLayerImpl(String mlVersion) {
        String implementation = null;
        for (Map.Entry<String, String> entry : COMPATIBILITY_IMPLEMENTATIONS.entrySet()) {
            if (!mlVersion.startsWith(entry.getKey())) continue;
            implementation = entry.getValue();
            break;
        }
        if (implementation == null) {
            throw new UnsupportedOperationException("Unable to find a matching compatibility layer for ModLauncher version " + mlVersion);
        }
        try {
            Class<?> clazz = Class.forName("gg.essential.loader.stage2.modlauncher." + implementation);
            return (CompatibilityLayer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    @NotNull
    public List<ITransformer> transformers() {
        return Collections.emptyList();
    }

    private void configureLayerToBeSortedByVersion(IModuleLayerManager.Layer layer) {
        try {
            IModuleLayerManager layerManager = (IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow();
            Field layersField = layerManager.getClass().getDeclaredField("layers");
            layersField.setAccessible(true);
            Map layers = (Map)layersField.get(layerManager);
            layers.compute(layer, (__, list) -> {
                SortedJarOrPathList sortedList = new SortedJarOrPathList(this.kffMerger::maybeMergeInto);
                if (list != null) {
                    sortedList.addAll((Collection<?>)list);
                }
                return sortedList;
            });
        }
        catch (Throwable t) {
            LOGGER.error("Failed to replace mod list of " + layer + " with sorted list:", t);
        }
    }

    private boolean injectMods() {
        try {
            Field modValidatorField = FMLLoader.class.getDeclaredField("modValidator");
            modValidatorField.setAccessible(true);
            ModValidator modValidator = (ModValidator)modValidatorField.get(null);
            if (modValidator == null) {
                return false;
            }
            Field candidateModsField = ModValidator.class.getDeclaredField("candidateMods");
            candidateModsField.setAccessible(true);
            List modFiles = (List)candidateModsField.get(modValidator);
            for (ModFile modFile : this.modLocator.scanMods(this.gameJars.stream().map(SecureJar::getPrimaryPath))) {
                modFile.identifyMods();
                modFiles.add(modFile);
            }
            return true;
        }
        catch (Throwable e) {
            LOGGER.error("Error injecting into mod list:", e);
            return false;
        }
    }

    public List<ITransformationService.Resource> beginScanning(IEnvironment environment) {
        String mcVersion = "forge_" + FMLLoader.versionInfo().mcVersion();
        ActualEssentialLoader essentialLoader = new ActualEssentialLoader(this.gameDir, mcVersion, this);
        try {
            essentialLoader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.injectMods()) {
            this.modsInjected = true;
        }
        this.configureLayerToBeSortedByVersion(IModuleLayerManager.Layer.PLUGIN);
        return List.of(new ITransformationService.Resource(IModuleLayerManager.Layer.PLUGIN, this.pluginJars));
    }

    public List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        if (!this.modsInjected && this.injectMods()) {
            this.modsInjected = true;
        }
        if (!this.modsInjected) {
            LOGGER.error("Failed to inject Essential into Forge mod list, falling back to Mixin-only operation. Mod will not be listed in Forge's mod list.");
            this.configureLayerToBeSortedByVersion(IModuleLayerManager.Layer.GAME);
            return Collections.singletonList(new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, this.gameJars));
        }
        return List.of();
    }
}

