/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.util;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import gg.essential.loader.stage2.DescriptorRewritingJarMetadata;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KFFMerger {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern JIJ_KOTLIN_FILES = Pattern.compile("kotlinx?-([a-z0-9-]+)-(\\d+\\.\\d+\\.\\d+)\\.jar");
    private static final byte[] EMPTY_ZIP = new byte[]{80, 75, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final Libraries ourCoreJars = new Libraries("Kotlin core");
    private final Libraries ourCoroutinesJars = new Libraries("Kotlin Coroutines");
    private final Libraries ourSerializationJars = new Libraries("Kotlin Serialization");

    public boolean addKotlinJar(Path sourceFile, SecureJar secureJar) {
        Libraries libraries;
        String fileName = sourceFile.getFileName().toString();
        Matcher matcher = JIJ_KOTLIN_FILES.matcher(fileName);
        if (!matcher.matches()) {
            return false;
        }
        switch (matcher.group(1)) {
            case "stdlib": 
            case "stdlib-common": 
            case "stdlib-jdk7": 
            case "stdlib-jdk8": 
            case "reflect": {
                Libraries libraries2 = this.ourCoreJars;
                break;
            }
            case "coroutines-core-jvm": 
            case "coroutines-jdk8": {
                Libraries libraries2 = this.ourCoroutinesJars;
                break;
            }
            case "serialization-core-jvm": 
            case "serialization-json-jvm": {
                Libraries libraries2 = this.ourSerializationJars;
                break;
            }
            default: {
                Libraries libraries2 = libraries = null;
            }
        }
        if (libraries == null) {
            LOGGER.warn("Do not know how to classify {}, will inject it as a regular lib.", (Object)fileName);
            return false;
        }
        int version = KFFMerger.version(matcher.group(2));
        if (libraries.version != 0 && libraries.version != version) {
            LOGGER.warn("Conflicting version for {}:\nExisting ({}): {}\nNew ({}): {}", (Object)libraries, (Object)KFFMerger.versionStr(libraries.version), (Object)libraries.jars.get(0), (Object)KFFMerger.versionStr(version), (Object)secureJar);
        }
        libraries.jars.add(secureJar);
        libraries.version = version;
        return true;
    }

    public SecureJar maybeMergeInto(final SecureJar secureJar) {
        if (this.ourCoreJars.jars.isEmpty()) {
            return secureJar;
        }
        if (!secureJar.getPackages().contains("kotlin")) {
            return secureJar;
        }
        LOGGER.info("Found Kotlin-containing mod {}, checking whether we need to upgrade it..", (Object)secureJar);
        Path rootPath = secureJar.getRootPath();
        int theirCoreVersion = this.detectKotlinCoreVersion(secureJar, rootPath);
        int theirCoroutinesVersion = this.detectKotlinCoroutinesVersion(secureJar, rootPath);
        boolean updateCore = theirCoreVersion < this.ourCoreJars.version;
        boolean updateCoroutines = theirCoroutinesVersion < this.ourCoroutinesJars.version;
        int theirSerializationVersion = updateCore || updateCoroutines ? 0 : this.ourSerializationJars.version;
        ArrayList<Path> injectedJars = new ArrayList<Path>();
        this.ourCoreJars.maybeUpgrade(injectedJars, theirCoreVersion);
        this.ourCoroutinesJars.maybeUpgrade(injectedJars, theirCoroutinesVersion);
        this.ourSerializationJars.maybeUpgrade(injectedJars, theirSerializationVersion);
        if (injectedJars.isEmpty()) {
            LOGGER.info("All good, no update needed: {}", (Object)secureJar);
            return secureJar;
        }
        try {
            JarMetadata orgMeta = JarMetadata.from((SecureJar)secureJar, (Path[])new Path[]{secureJar.getPrimaryPath()});
            Path tmpFile = Files.createTempFile("kff-updated-kotlin-", "-" + orgMeta.version() + ".jar", new FileAttribute[0]);
            Files.write(tmpFile, EMPTY_ZIP, new OpenOption[0]);
            LOGGER.info("Generating jar with updated Kotlin at {}", (Object)tmpFile);
            injectedJars.add(secureJar.getRootPath());
            try (FileSystem destFileSystem = FileSystems.newFileSystem(tmpFile);){
                HashSet<String> seen = new HashSet<String>();
                seen.add("");
                for (Path sourceRoot : injectedJars) {
                    Stream<Path> stream = Files.walk(sourceRoot, new FileVisitOption[0]);
                    try {
                        for (Path sourcePath : stream.toList()) {
                            String relativePath = sourceRoot.relativize(sourcePath).toString();
                            if (!seen.add(relativePath)) continue;
                            Path destinationPath = destFileSystem.getPath(relativePath, new String[0]);
                            if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                                Files.createDirectory(destinationPath, new FileAttribute[0]);
                                continue;
                            }
                            Files.copy(sourcePath, destinationPath, new CopyOption[0]);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                Path sourceManifest = secureJar.getRootPath().resolve("META-INF").resolve("MANIFEST.MF");
                Path destinationManifest = destFileSystem.getPath("META-INF", "MANIFEST.MF");
                if (Files.exists(sourceManifest, new LinkOption[0])) {
                    Files.copy(sourceManifest, destinationManifest, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            return SecureJar.from(j -> new DescriptorRewritingJarMetadata((SecureJar)j, orgMeta){

                @Override
                public String name() {
                    return secureJar.name();
                }
            }, (Path[])new Path[]{tmpFile});
        }
        catch (Throwable t) {
            LOGGER.fatal("Failed to merge updated Kotlin into " + secureJar + ":", t);
            return secureJar;
        }
    }

    private int detectKotlinCoreVersion(SecureJar jar, Path root) {
        try {
            if (Files.notExists(root.resolve("kotlin").resolve("KotlinVersion.class"), new LinkOption[0])) {
                return 0;
            }
            URL url = root.toUri().toURL();
            url = url.getProtocol().equals("jar") && url.getPath().endsWith("!/") ? new URL(url.getPath().substring(0, url.getPath().length() - 2)) : new URL(url.getProtocol(), url.getHost(), url.getFile() + "/");
            URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
            Class<?> kotlinVersionClass = classLoader.loadClass("kotlin.KotlinVersion");
            Field currentField = kotlinVersionClass.getDeclaredField("CURRENT");
            Object kotlinVersion = currentField.get(null);
            int major = (Integer)kotlinVersionClass.getDeclaredMethod("getMajor", new Class[0]).invoke(kotlinVersion, new Object[0]);
            int minor = (Integer)kotlinVersionClass.getDeclaredMethod("getMinor", new Class[0]).invoke(kotlinVersion, new Object[0]);
            int patch = (Integer)kotlinVersionClass.getDeclaredMethod("getPatch", new Class[0]).invoke(kotlinVersion, new Object[0]);
            return KFFMerger.version(major, minor, patch);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to determine Kotlin Core version in " + jar + ":", t);
            return 0;
        }
    }

    private int detectKotlinCoroutinesVersion(SecureJar jar, Path root) {
        try {
            Path versionFile = root.resolve("META-INF").resolve("kotlinx_coroutines_core.version");
            if (Files.notExists(versionFile, new LinkOption[0])) {
                return 0;
            }
            return KFFMerger.version(Files.readString(versionFile));
        }
        catch (Throwable t) {
            LOGGER.error("Failed to determine Kotlin Coroutines version in " + jar + ":", t);
            return 0;
        }
    }

    private static int version(String str) {
        String[] parts = str.trim().split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        int patch = Integer.parseInt(parts[2]);
        return KFFMerger.version(major, minor, patch);
    }

    private static int version(int major, int minor, int patch) {
        return major << 16 | minor << 8 | patch;
    }

    private static String versionStr(int version) {
        return KFFMerger.versionStr(version >> 16, version >> 8 & 0xFF, version & 0xFF);
    }

    private static String versionStr(int major, int minor, int patch) {
        return major + "." + minor + "." + patch;
    }

    private static class Libraries {
        private final String name;
        private final List<SecureJar> jars = new ArrayList<SecureJar>();
        private int version;

        private Libraries(String name) {
            this.name = name;
        }

        public void maybeUpgrade(List<Path> injectedJars, int theirVersion) {
            if (theirVersion < this.version) {
                LOGGER.info("Found outdated {} libs {} (we ship {})", (Object)this.name, (Object)KFFMerger.versionStr(theirVersion), (Object)KFFMerger.versionStr(this.version));
                for (SecureJar jar : this.jars) {
                    injectedJars.add(jar.getRootPath());
                }
            } else {
                LOGGER.info("Found up-to-date {} libs {} (we ship {})", (Object)this.name, (Object)KFFMerger.versionStr(theirVersion), (Object)KFFMerger.versionStr(this.version));
            }
        }
    }
}

