/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.util;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.NamedPath;
import gg.essential.loader.stage2.util.UnsafeHacks;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class SortedJarOrPathList
extends ArrayList<Object> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ArtifactVersion FALLBACK_VERSION = new DefaultArtifactVersion("1");
    private static Function<Object, SecureJar> jarGetter;
    private Function<SecureJar, JarMetadata> metadataGetter;
    private BiFunction<NamedPath, SecureJar, Object> pathOrJarConstructor;
    private final Map<Object, ArtifactVersion> versionCache = new IdentityHashMap<Object, ArtifactVersion>();
    private final Comparator<Object> COMPARATOR = Comparator.comparing(pathOrJar -> this.versionCache.computeIfAbsent(pathOrJar, this::getVersion)).reversed();
    private final Function<SecureJar, SecureJar> substitute;

    public SortedJarOrPathList(Function<SecureJar, SecureJar> substitute) {
        this.substitute = substitute;
    }

    private ArtifactVersion getVersion(Object pathOrJar) {
        SecureJar jar = SortedJarOrPathList.getJar(pathOrJar);
        if (jar == null) {
            return FALLBACK_VERSION;
        }
        JarMetadata metadata = this.getMetadata(jar);
        if (metadata == null) {
            return FALLBACK_VERSION;
        }
        String version = metadata.version();
        if (version == null) {
            return FALLBACK_VERSION;
        }
        return new DefaultArtifactVersion(version);
    }

    public static SecureJar getJar(Object pathOrJar) {
        Object object = pathOrJar;
        if (object instanceof SecureJar) {
            SecureJar secureJar = (SecureJar)object;
            return secureJar;
        }
        if (jarGetter == null) {
            try {
                Field jarField = pathOrJar.getClass().getDeclaredField("jar");
                jarField.setAccessible(true);
                jarGetter = wrapper -> {
                    try {
                        return (SecureJar)jarField.get(wrapper);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Failed to get jar from PathOrJar:", t);
                        return null;
                    }
                };
            }
            catch (Throwable t) {
                LOGGER.error("Failed to get jar from PathOrJar:", t);
                jarGetter = __ -> null;
            }
        }
        return jarGetter.apply(pathOrJar);
    }

    private JarMetadata getMetadata(SecureJar jar) {
        if (this.metadataGetter == null) {
            try {
                this.metadataGetter = UnsafeHacks.makeGetter(jar.getClass().getDeclaredField("metadata"));
            }
            catch (Throwable t) {
                LOGGER.error("Failed to get metadata from " + jar.getClass() + ":", t);
                this.metadataGetter = __ -> null;
            }
        }
        return this.metadataGetter.apply(jar);
    }

    @Override
    public boolean add(Object o) {
        boolean changed = super.add(this.substitute(o));
        this.sort(this.COMPARATOR);
        return changed;
    }

    @Override
    public boolean addAll(Collection<?> c) {
        boolean changed = super.addAll(c.stream().map(this::substitute).toList());
        this.sort(this.COMPARATOR);
        return changed;
    }

    private Object substitute(Object orgPathOrJar) {
        Object newPathOrJar;
        SecureJar orgJar = SortedJarOrPathList.getJar(orgPathOrJar);
        if (orgJar == null) {
            return orgPathOrJar;
        }
        SecureJar newJar = this.substitute.apply(orgJar);
        if (newJar == orgJar) {
            return orgPathOrJar;
        }
        if (orgPathOrJar instanceof SecureJar) {
            return newJar;
        }
        if (this.pathOrJarConstructor == null) {
            try {
                Constructor<?> constructor = orgPathOrJar.getClass().getDeclaredConstructors()[0];
                constructor.setAccessible(true);
                this.pathOrJarConstructor = (path, jar) -> {
                    try {
                        return constructor.newInstance(path, jar);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Failed to construct PathOrJar:", t);
                        return null;
                    }
                };
            }
            catch (Throwable t) {
                LOGGER.error("Failed to construct PathOrJar:", t);
                this.pathOrJarConstructor = (path, jar) -> null;
            }
        }
        if ((newPathOrJar = this.pathOrJarConstructor.apply(null, newJar)) == null) {
            return orgPathOrJar;
        }
        return newPathOrJar;
    }
}

