/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.u_team_core.api.block.BlockItemProvider;
import info.u_team.useful_railroads.init.UsefulRailroadsCreativeTabs;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public abstract class CustomPoweredRailBlock
extends PoweredRailBlock
implements BlockItemProvider {
    protected final BlockItem blockItem = this.createBlockItem(new Item.Properties().m_41491_((CreativeModeTab)UsefulRailroadsCreativeTabs.GROUP));
    protected final double minSpeed = 0.01;

    public CustomPoweredRailBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.7f).m_60918_(SoundType.f_56743_), true);
    }

    protected BlockItem createBlockItem(Item.Properties blockItemProperties) {
        return new BlockItem((Block)this, blockItemProperties);
    }

    public BlockItem blockItem() {
        return this.blockItem;
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        this.moveAlongTrack(pos, state, cart);
    }

    protected void moveAlongTrack(BlockPos pos, BlockState state, AbstractMinecart cart) {
        BaseRailBlock railBlock = (BaseRailBlock)state.m_60734_();
        RailShape railDirection = railBlock.getRailDirection(state, (BlockGetter)cart.f_19853_, pos, cart);
        boolean powered = railBlock == this ? (Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_) : false;
        double currentSpeed = CustomPoweredRailBlock.getPlaneSqrtDistance(cart.m_20184_());
        if (currentSpeed < 0.01) {
            if (cart.shouldDoRailFunctions() && powered) {
                this.doPushOffWall(pos, cart, railDirection, cart.m_20184_());
            }
            this.doPassengerPush(cart);
        } else if (cart.shouldDoRailFunctions()) {
            if (powered) {
                this.doPoweredMovement(pos, state, cart, railDirection);
            } else {
                this.doUnpoweredMovement(cart);
            }
        }
    }

    protected void doPassengerPush(AbstractMinecart cart) {
        Vec3 passengerMotion;
        double passengerDistanceSqr;
        Entity passenger;
        Entity entity = passenger = cart.m_20197_().isEmpty() ? null : (Entity)cart.m_20197_().get(0);
        if (passenger instanceof Player && (passengerDistanceSqr = CustomPoweredRailBlock.getPlaneSqrDistance(passengerMotion = passenger.m_20184_())) > 1.0E-4) {
            cart.m_20256_(cart.m_20184_().m_82520_(passengerMotion.f_82479_ * 0.1, 0.0, passengerMotion.f_82481_ * 0.1));
        }
    }

    protected void doUnpoweredMovement(AbstractMinecart cart) {
        double currentSpeed = CustomPoweredRailBlock.getPlaneSqrtDistance(cart.m_20184_());
        if (currentSpeed < 0.01) {
            cart.m_20256_(Vec3.f_82478_);
        } else {
            cart.m_20256_(cart.m_20184_().m_82542_(0.5, 0.0, 0.5));
        }
    }

    protected void doPoweredMovement(BlockPos pos, BlockState state, AbstractMinecart cart, RailShape railDirection) {
        this.controlSpeed(pos, state, cart);
    }

    protected void doPushOffWall(BlockPos pos, AbstractMinecart cart, RailShape railDirection, Vec3 cartMotion) {
        double xCartMotion = cartMotion.f_82479_;
        double zCartMotion = cartMotion.f_82481_;
        if (railDirection == RailShape.EAST_WEST) {
            if (CustomPoweredRailBlock.isNormalCube(cart.f_19853_, pos.m_122024_())) {
                xCartMotion = 0.01;
            } else if (CustomPoweredRailBlock.isNormalCube(cart.f_19853_, pos.m_122029_())) {
                xCartMotion = -0.01;
            }
        } else if (railDirection == RailShape.NORTH_SOUTH) {
            if (CustomPoweredRailBlock.isNormalCube(cart.f_19853_, pos.m_122012_())) {
                zCartMotion = 0.01;
            } else if (CustomPoweredRailBlock.isNormalCube(cart.f_19853_, pos.m_122019_())) {
                zCartMotion = -0.01;
            }
        } else {
            return;
        }
        cart.m_20334_(xCartMotion, cartMotion.f_82480_, zCartMotion);
    }

    protected void controlSpeed(BlockPos pos, BlockState state, AbstractMinecart cart) {
        Vec3 cartMotion = cart.m_20184_();
        double cartDistance = CustomPoweredRailBlock.getPlaneSqrtDistance(cartMotion);
        cart.m_20256_(cartMotion.m_82520_(cartMotion.f_82479_ / cartDistance * 0.06, 0.0, cartMotion.f_82481_ / cartDistance * 0.06));
    }

    protected void speedUpCart(AbstractMinecart cart, double accel, double speedClamp) {
        Vec3 motion = cart.m_20184_();
        double speed = motion.m_82553_();
        double newSpeed = Mth.m_14008_((double)(speed + accel), (double)(-speedClamp), (double)speedClamp);
        this.setCartSpeed(cart, newSpeed, motion);
    }

    protected void setCartSpeed(AbstractMinecart cart, double speed) {
        this.setCartSpeed(cart, speed, cart.m_20184_());
    }

    protected void setCartSpeed(AbstractMinecart cart, double speed, Vec3 direction) {
        Vec3 directionNormalised = direction.m_82541_();
        this.setCartSpeed(cart, directionNormalised.m_82559_(new Vec3(speed, speed, speed)));
    }

    protected void setCartSpeed(AbstractMinecart cart, double velX, double velY, double velZ) {
        this.setCartSpeed(cart, new Vec3(velX, velY, velZ));
    }

    protected void setCartSpeed(AbstractMinecart cart, Vec3 vel) {
        cart.m_20256_(vel);
        cart.m_6478_(MoverType.SELF, vel);
    }

    private static boolean isNormalCube(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60796_((BlockGetter)level, pos);
    }

    private static double getPlaneSqrtDistance(Vec3 vec) {
        return Math.sqrt(CustomPoweredRailBlock.getPlaneSqrDistance(vec));
    }

    private static double getPlaneSqrDistance(Vec3 vec) {
        return vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_;
    }
}

