/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.data.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.data.CommonBlockStateProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.useful_railroads.block.BufferStopBlock;
import info.u_team.useful_railroads.block.CustomAdvancedBlockEntityRailBlock;
import info.u_team.useful_railroads.block.CustomPoweredRailBlock;
import info.u_team.useful_railroads.block.DirectionRailBlock;
import info.u_team.useful_railroads.init.UsefulRailroadsBlocks;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.IGeneratedBlockState;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class UsefulRailroadsBlockStateProvider
extends CommonBlockStateProvider {
    private final Constructor<VariantBlockStateBuilder.PartialBlockstate> PARTIAL_BLOCK_STATE_CONSTRUCTOR = ObfuscationReflectionHelper.findConstructor(VariantBlockStateBuilder.PartialBlockstate.class, (Class[])new Class[]{Block.class, Map.class, VariantBlockStateBuilder.class});
    private final Constructor<VariantBlockStateBuilder> VARIANT_BLOCK_STATE_BUILDER_CONSTRUCTOR = ObfuscationReflectionHelper.findConstructor(VariantBlockStateBuilder.class, (Class[])new Class[]{Block.class});

    public UsefulRailroadsBlockStateProvider(GenerationData generationData) {
        super(generationData);
    }

    public void register() {
        this.customFlatPoweredRail((CustomPoweredRailBlock)UsefulRailroadsBlocks.HIGHSPEED_RAIL.get(), (ModelFile)this.flatRail("highspeed_rail"), (ModelFile)this.flatRail("highspeed_powered_rail"));
        this.customFlatPoweredRail((CustomPoweredRailBlock)UsefulRailroadsBlocks.SPEED_CLAMP_RAIL.get(), (ModelFile)this.flatRail("clamp_rail"), (ModelFile)this.flatRail("clamp_powered_rail"));
        this.forAllFlatRailStates(this.getUncheckedVariantBuilder(UsefulRailroadsBlocks.DIRECTION_RAIL.get()), state -> {
            RailShape shape = (RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_);
            boolean powered = (Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_);
            boolean positiveAxis = (Boolean)state.m_61143_((Property)DirectionRailBlock.AXIS_DIRECTION);
            return ConfiguredModel.builder().modelFile((ModelFile)(powered ? this.flatRail("direction_powered_rail") : this.flatRail("direction_rail"))).rotationY((shape == RailShape.EAST_WEST ? -90 : 0) + (positiveAxis ? 180 : 0)).build();
        });
        this.simpleBlock(UsefulRailroadsBlocks.INTERSECTION_RAIL.get(), (ModelFile)this.flatRail("intersection_rail"));
        this.customFlatPoweredRail((CustomPoweredRailBlock)UsefulRailroadsBlocks.TELEPORT_RAIL.get(), (ModelFile)this.flatRail("teleport_rail"), (ModelFile)this.flatRail("teleport_powered_rail"));
        this.getVariantBuilder(UsefulRailroadsBlocks.BUFFER_STOP.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/buffer_stop"), this.models().existingFileHelper)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build(), new Property[]{BufferStopBlock.POWERED, CustomAdvancedBlockEntityRailBlock.SHAPE});
    }

    private void customFlatPoweredRail(CustomPoweredRailBlock block, ModelFile normal, ModelFile powered) {
        this.customFlatPoweredRail(block, blockState -> (Boolean)blockState.m_61143_((Property)PoweredRailBlock.f_55215_) != false ? powered : normal);
    }

    private void customFlatPoweredRail(CustomPoweredRailBlock block, Function<BlockState, ModelFile> modelFunc) {
        this.forAllFlatRailStates(this.getUncheckedVariantBuilder((Block)block), state -> {
            RailShape shape = (RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(shape == RailShape.EAST_WEST ? 90 : 0).build();
        });
    }

    private VariantBlockStateBuilder forAllFlatRailStates(VariantBlockStateBuilder builder, Function<BlockState, ConfiguredModel[]> mapper) {
        HashSet seen = new HashSet();
        if (!(builder.getOwner() instanceof CustomPoweredRailBlock)) {
            throw new IllegalArgumentException("This method only allow custom powered rail blocks");
        }
        builder.getOwner().m_49965_().m_61056_().forEach(fullState -> {
            RailShape shape;
            LinkedHashMap propertyValues = Maps.newLinkedHashMap((Map)fullState.m_61148_());
            propertyValues.remove(BaseRailBlock.f_152149_);
            VariantBlockStateBuilder.PartialBlockstate partialState = this.newPartialBlockState(builder.getOwner(), propertyValues, builder);
            if (seen.add(partialState) && ((shape = (RailShape)fullState.m_61143_((Property)PoweredRailBlock.f_55214_)) == RailShape.NORTH_SOUTH || shape == RailShape.EAST_WEST)) {
                builder.setModels(partialState, (ConfiguredModel[])mapper.apply((BlockState)fullState));
            }
        });
        return builder;
    }

    private BlockModelBuilder flatRail(String name) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/rail_flat")).texture("rail", this.modLoc("block/" + name))).renderType("cutout");
    }

    private VariantBlockStateBuilder.PartialBlockstate newPartialBlockState(Block owner, Map<Property<?>, Comparable<?>> setStates, VariantBlockStateBuilder outerBuilder) {
        try {
            return this.PARTIAL_BLOCK_STATE_CONSTRUCTOR.newInstance(owner, setStates, outerBuilder);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot create new PartialBlockstate with reflection.", ex);
        }
    }

    private VariantBlockStateBuilder newVariantBlockStateBuilder(Block block) {
        try {
            return this.VARIANT_BLOCK_STATE_BUILDER_CONSTRUCTOR.newInstance(block);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot create new VariantBlockStateBuilder with reflection.", ex);
        }
    }

    private VariantBlockStateBuilder getUncheckedVariantBuilder(Block block) {
        if (this.registeredBlocks.containsKey(block)) {
            IGeneratedBlockState old = (IGeneratedBlockState)this.registeredBlocks.get(block);
            Preconditions.checkState((boolean)(old instanceof VariantBlockStateBuilder));
            return (VariantBlockStateBuilder)old;
        }
        VariantBlockStateBuilder ret = this.newVariantBlockStateBuilder(block);
        this.registeredBlocks.put(block, () -> {
            JsonObject variants = new JsonObject();
            ret.getModels().entrySet().stream().sorted(Map.Entry.comparingByKey(VariantBlockStateBuilder.PartialBlockstate.comparingByProperties())).forEach(entry -> variants.add(((VariantBlockStateBuilder.PartialBlockstate)entry.getKey()).toString(), ((BlockStateProvider.ConfiguredModelList)entry.getValue()).toJSON()));
            JsonObject main = new JsonObject();
            main.add("variants", (JsonElement)variants);
            return main;
        });
        return ret;
    }
}

