/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.item;

import info.u_team.u_team_core.item.UItem;
import info.u_team.u_team_core.util.TooltipCreator;
import info.u_team.useful_railroads.config.ServerConfig;
import info.u_team.useful_railroads.init.UsefulRailroadsCreativeTabs;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.menu.TrackBuilderMenu;
import info.u_team.useful_railroads.util.TrackBuilderManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class TrackBuilderItem
extends UItem {
    private final boolean doubleTrack;

    public TrackBuilderItem(boolean doubleTrack) {
        super((CreativeModeTab)UsefulRailroadsCreativeTabs.GROUP, new Item.Properties().m_41487_(1).m_41497_(doubleTrack ? Rarity.EPIC : Rarity.RARE));
        this.doubleTrack = doubleTrack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && !player.m_6144_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TrackBuilderInventoryWrapper.Server wrapper = new TrackBuilderInventoryWrapper.Server(stack, () -> player.f_19853_);
            int selectedSlot = hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : -1;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, playerInventory, openPlayer) -> new TrackBuilderMenu(id, playerInventory, wrapper, selectedSlot), (Component)Component.m_237115_((String)"container.usefulrailroads.track_builder")), buffer -> {
                buffer.m_130130_(wrapper.getFuel());
                buffer.m_130068_((Enum)wrapper.getMode());
                buffer.m_130130_(selectedSlot);
            });
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null || !context.m_7078_() || context.m_43724_() == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        TrackBuilderInventoryWrapper.Server wrapper = new TrackBuilderInventoryWrapper.Server(context.m_43722_(), () -> player.f_19853_);
        TrackBuilderManager.create(context.m_8083_(), context.m_43719_(), level, player.m_20154_(), wrapper.getMode(), this.doubleTrack).ifPresent(manager -> manager.execute(player, wrapper));
        return InteractionResult.SUCCESS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41746_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public CompoundTag getShareTag(ItemStack stack) {
        if (((Boolean)ServerConfig.getInstance().shareAllNBTData.get()).booleanValue()) {
            return super.getShareTag(stack);
        }
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag compound = stack.m_41783_().m_6426_();
        compound.m_128473_("Items");
        if (compound.m_128456_()) {
            return null;
        }
        return compound;
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        return !(player.f_36096_ instanceof TrackBuilderMenu);
    }

    public boolean isDoubleTrack() {
        return this.doubleTrack;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)TooltipCreator.create((Item)this, (String)"", (int)0, (Object[])new Object[]{TooltipCreator.create((String)"usefulrailroads", (String)"click", (String)"right_click", (int)0).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD})}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)TooltipCreator.create((Item)this, (String)"", (int)1, (Object[])new Object[]{TooltipCreator.create((String)"usefulrailroads", (String)"click", (String)"shift_right_click", (int)0).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD})}).m_130940_(ChatFormatting.GRAY));
    }
}

