/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.handler;

import fuzs.magnumtorch.MagnumTorch;
import fuzs.magnumtorch.config.ServerConfig;
import fuzs.magnumtorch.world.level.block.MagnumTorchBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobSpawningHandler {
    public static boolean onLivingSpawn(Entity entity, ServerLevel level, @Nullable MobSpawnType spawnType) {
        if (spawnType == null || !MagnumTorch.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
            return true;
        }
        for (MagnumTorchBlock.Type type : MagnumTorchBlock.Type.values()) {
            if (!MobSpawningHandler.isSpawnCancelled(level.m_8904_(), entity.m_6095_(), entity.m_20183_(), spawnType, type.getPoiTypeKey(), type.getConfig())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpawnCancelled(PoiManager poiManager, EntityType<?> entityType, BlockPos toCheck, @NotNull MobSpawnType spawnType, ResourceKey<PoiType> poiTypeKey, ServerConfig.MagnumTorchConfig config) {
        if (config.blockedSpawnTypes.contains(spawnType) && config.isAffected(entityType)) {
            return poiManager.m_27138_(poiType -> poiType.m_203565_(poiTypeKey), $ -> true, toCheck, (int)Math.ceil(Math.sqrt(config.horizontalRange * config.horizontalRange + config.verticalRange * config.verticalRange)), PoiManager.Occupancy.ANY).anyMatch(pos -> config.shapeType.isPositionContained((BlockPos)pos, toCheck, config.horizontalRange, config.verticalRange));
        }
        return false;
    }
}

