/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Streams;
import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public abstract class CommonItemModelProvider
extends ItemModelProvider
implements CommonDataProvider.NoParam {
    private final GenerationData generationData;

    public CommonItemModelProvider(GenerationData generationData) {
        super(generationData.generator(), generationData.modid(), generationData.existingFileHelper());
        this.generationData = generationData;
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    protected final void registerModels() {
        this.register(null);
    }

    public String m_6055_() {
        return "Item-Model";
    }

    protected void simpleGenerated(ItemLike provider) {
        this.simpleParent(provider, "item/generated");
    }

    protected void simpleHandheld(ItemLike provider) {
        this.simpleParent(provider, "item/handheld");
    }

    protected void spawnEgg(ItemLike provider) {
        this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)provider.m_5456_()).m_135815_(), "item/template_spawn_egg");
    }

    protected void simpleParent(ItemLike provider, String parent) {
        String registryPath = ForgeRegistries.ITEMS.getKey((Object)provider.m_5456_()).m_135815_();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(registryPath)).parent((ModelFile)new ModelFile.UncheckedModelFile(parent))).texture("layer0", "item/" + registryPath);
    }

    protected void simpleBlock(Block block) {
        ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        ((ItemModelBuilder)this.getBuilder(registryName.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(registryName.m_135827_(), "block/" + registryName.m_135815_())));
    }

    protected void iterateItems(Iterable<? extends Supplier<? extends Item>> iterable, Consumer<ItemLike> item) {
        Streams.stream(iterable).map(Supplier::get).forEach(item);
    }

    protected void iterateBlocks(Iterable<? extends RegistryObject<? extends Block>> iterable, Consumer<ItemLike> item) {
        Streams.stream(iterable).map(Supplier::get).forEach(item);
    }

    protected String getPath(ItemLike provider) {
        return ForgeRegistries.ITEMS.getKey((Object)provider.m_5456_()).m_135815_();
    }
}

