/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import info.u_team.u_team_core.gui.elements.ScalableText;
import info.u_team.u_team_core.util.RenderUtil;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.util.Mth;

public class ScrollingText
extends ScalableText {
    protected int width = 100;
    protected float stepSize = 1.0f;
    protected int speedTime = 20;
    protected int waitTime = 4000;
    protected float moveDifference = 0.0f;
    protected long lastTime = 0L;
    protected State state = State.WAITING;

    public ScrollingText(Font font, Supplier<String> textSupplier, float x, float y) {
        super(font, textSupplier, x, y);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    public int getSpeedTime() {
        return this.speedTime;
    }

    public void setSpeedTime(int speedtime) {
        this.speedTime = speedtime;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waittime) {
        this.waitTime = waittime;
    }

    public void copyState(ScrollingText renderer) {
        this.setText((String)this.textSupplier.get());
        this.state = renderer.state;
        this.moveDifference = renderer.moveDifference;
        this.lastTime = renderer.lastTime;
    }

    @Override
    protected void updatedText() {
        this.state = State.WAITING;
        this.moveDifference = 0.0f;
        this.lastTime = 0L;
        super.updatedText();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        Window window = minecraft.m_91268_();
        RenderUtil.Matrix4fExtended matrix = new RenderUtil.Matrix4fExtended(poseStack.m_85850_().m_85861_());
        double scaleFactor = window.m_85449_();
        Vector4f vectorXY = new Vector4f(this.x, this.y, 0.0f, 1.0f);
        vectorXY.m_123607_((Matrix4f)matrix);
        float f = (float)this.width * matrix.getM00();
        Objects.requireNonNull(this.font);
        Vector4f vectorWH = new Vector4f(f, (float)(9 + 1) * this.scale * matrix.getM11(), 0.0f, 1.0f);
        int nativeX = Mth.m_14165_((double)((double)vectorXY.m_123601_() * scaleFactor));
        int nativeY = Mth.m_14165_((double)((double)vectorXY.m_123615_() * scaleFactor));
        int nativeWidth = Mth.m_14165_((double)((double)vectorWH.m_123601_() * scaleFactor));
        int nativeHeight = Mth.m_14165_((double)((double)vectorWH.m_123615_() * scaleFactor));
        RenderSystem.m_69488_((int)nativeX, (int)(window.m_85444_() - (nativeY + nativeHeight)), (int)nativeWidth, (int)nativeHeight);
        this.setText((String)this.textSupplier.get());
        this.renderFont(poseStack, this.font, this.getMovingX(this.x), this.y + 2.0f * this.scale);
        RenderSystem.m_69471_();
    }

    protected float getMovingX(float x) {
        float textWidth = this.getTextWidth();
        if ((float)this.width < textWidth) {
            float maxMove = (float)this.width - textWidth;
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            if (this.state == State.WAITING) {
                if (this.hasWaitTimePassed()) {
                    this.state = this.moveDifference >= 0.0f ? State.LEFT : State.RIGHT;
                    this.lastTime = 0L;
                }
            } else if (this.hasSpeedTimePassed()) {
                if (this.state == State.LEFT ? this.moveDifference >= maxMove : this.moveDifference <= 0.0f) {
                    this.moveDifference += this.state == State.LEFT ? -this.stepSize : this.stepSize;
                } else {
                    this.state = State.WAITING;
                }
                this.lastTime = 0L;
            }
            return x + this.moveDifference;
        }
        return x;
    }

    protected boolean hasWaitTimePassed() {
        return System.currentTimeMillis() - (long)this.waitTime >= this.lastTime;
    }

    protected boolean hasSpeedTimePassed() {
        return System.currentTimeMillis() - (long)this.speedTime >= this.lastTime;
    }

    private static enum State {
        WAITING,
        LEFT,
        RIGHT;

    }
}

