/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.menu.UContainerMenu;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public record DataHolderMenuMessage(int containerId, int index, FriendlyByteBuf dataHolderBuffer) {
    public static void encode(DataHolderMenuMessage message, FriendlyByteBuf byteBuf) {
        byteBuf.writeByte(message.containerId);
        byteBuf.writeShort(message.index);
        byteBuf.writeBytes((ByteBuf)message.dataHolderBuffer);
    }

    public static DataHolderMenuMessage decode(FriendlyByteBuf byteBuf) {
        byte containerId = byteBuf.readByte();
        short index = byteBuf.readShort();
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        return new DataHolderMenuMessage(containerId, index, new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bytes)));
    }

    public static class Handler {
        public static void handle(DataHolderMenuMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    Handler.handleClient(message);
                } else {
                    Handler.handleServer(message, context);
                }
            });
            context.setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void handleClient(DataHolderMenuMessage message) {
            Handler.updateDataHolder(Minecraft.m_91087_().f_91074_.f_36096_, LogicalSide.CLIENT, message);
        }

        private static void handleServer(DataHolderMenuMessage message, NetworkEvent.Context context) {
            Handler.updateDataHolder(context.getSender().f_36096_, LogicalSide.SERVER, message);
        }

        private static void updateDataHolder(AbstractContainerMenu menuToTest, LogicalSide side, DataHolderMenuMessage message) {
            Handler.testContainerMenu(menuToTest, message.containerId).ifPresent(menu -> menu.setDataHolder(side, message.index, message.dataHolderBuffer));
        }

        private static Optional<UContainerMenu> testContainerMenu(AbstractContainerMenu menu, int containerId) {
            if (menu instanceof UContainerMenu) {
                UContainerMenu uContainer = (UContainerMenu)menu;
                if (menu.f_38840_ == containerId) {
                    return Optional.of(uContainer);
                }
            }
            return Optional.empty();
        }
    }
}

