/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.item.armor;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class UArmorItem
extends ArmorItem {
    protected final String textureName;

    public UArmorItem(String textureName, Item.Properties properties, ArmorMaterial material, EquipmentSlot slot) {
        this(textureName, null, properties, material, slot);
    }

    public UArmorItem(String textureName, CreativeModeTab creativeTab, Item.Properties properties, ArmorMaterial material, EquipmentSlot slot) {
        super(material, slot, creativeTab == null ? properties : properties.m_41491_(creativeTab));
        this.textureName = textureName;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (!this.f_40379_.m_6082_().equals("invalid")) {
            return null;
        }
        return String.format("%s:textures/models/armor/%s_layer_%d%s.png", ForgeRegistries.ITEMS.getKey((Object)this).m_135827_(), this.textureName, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
    }

    protected String getTypeString(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> "helmet";
            case EquipmentSlot.CHEST -> "chestplate";
            case EquipmentSlot.LEGS -> "leggings";
            case EquipmentSlot.FEET -> "boots";
            default -> "invalid";
        };
    }
}

