/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.menu;

import info.u_team.u_team_core.api.sync.DataHolder;
import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.DataHolderMenuMessage;
import info.u_team.u_team_core.menu.FluidContainerMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.PacketDistributor;

public abstract class UContainerMenu
extends FluidContainerMenu {
    private final List<DataHolder> dataHolderToClient = new ArrayList<DataHolder>();
    private final List<DataHolder> dataHolderToServer = new ArrayList<DataHolder>();

    protected UContainerMenu(MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    protected <E extends DataHolder> E addDataHolderToClient(E holder) {
        this.dataHolderToClient.add(holder);
        return holder;
    }

    protected <E extends DataHolder> E addDataHolderToServer(E holder) {
        this.dataHolderToServer.add(holder);
        return holder;
    }

    @Override
    public void m_150429_() {
        super.m_150429_();
        if (this.getSynchronizerPlayer() != null) {
            for (int index = 0; index < this.dataHolderToClient.size(); ++index) {
                DataHolder dataHolder = this.dataHolderToClient.get(index);
                UCoreNetwork.NETWORK.send(PacketDistributor.PLAYER.with(this::getSynchronizerPlayer), (Object)new DataHolderMenuMessage(this.f_38840_, index, dataHolder.get()));
            }
        }
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        if (this.getSynchronizerPlayer() != null) {
            this.checkForChanges(this.dataHolderToClient, (index, dataHolder) -> UCoreNetwork.NETWORK.send(PacketDistributor.PLAYER.with(this::getSynchronizerPlayer), (Object)new DataHolderMenuMessage(this.f_38840_, (int)index, dataHolder.get())));
        }
    }

    public void broadcastChangesToServer() {
        this.checkForChanges(this.dataHolderToServer, (index, dataHolder) -> UCoreNetwork.NETWORK.send(PacketDistributor.SERVER.noArg(), (Object)new DataHolderMenuMessage(this.f_38840_, (int)index, dataHolder.get())));
    }

    public final void setDataHolder(LogicalSide side, int index, FriendlyByteBuf dataHolderBuffer) {
        if (side == LogicalSide.CLIENT) {
            this.dataHolderToClient.get(index).set(dataHolderBuffer);
        } else if (side == LogicalSide.SERVER) {
            this.dataHolderToServer.get(index).set(dataHolderBuffer);
        }
    }

    private void checkForChanges(List<DataHolder> dataHolders, BiConsumer<Integer, DataHolder> consumer) {
        for (int index = 0; index < dataHolders.size(); ++index) {
            DataHolder dataHolder = dataHolders.get(index);
            if (!dataHolder.checkAndClearUpdateFlag()) continue;
            consumer.accept(index, dataHolder);
        }
    }
}

