/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import info.u_team.u_team_core.util.GsonUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class ConfigUtil {
    public static final String JSON_EXTENSION = ".json";

    public static <T> T loadConfig(Path directory, String name, Gson gson, Function<JsonWriter, T> write, Function<BufferedReader, T> read) throws IOException {
        return ConfigUtil.loadConfig(directory, name, JSON_EXTENSION, gson, write, read);
    }

    public static <T> T loadConfig(Path directory, String name, String extension, Gson gson, Function<JsonWriter, T> write, Function<BufferedReader, T> read) throws IOException {
        Path path = directory.resolve(name + extension);
        if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path) && Files.isReadable(path)) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                T t = read.apply(reader);
                return t;
            }
        }
        Files.deleteIfExists(path);
        Files.createDirectories(directory, new FileAttribute[0]);
        Files.createFile(path, new FileAttribute[0]);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            T t;
            block19: {
                JsonWriter writer = GsonUtil.createTabWriter(gson, bufferedWriter);
                try {
                    t = write.apply(writer);
                    if (writer == null) break block19;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return t;
        }
    }

    public static <T> T loadConfig(Path directory, String name, Gson gson, T defaultValue, BiConsumer<JsonWriter, T> write, Function<BufferedReader, T> read) throws IOException {
        return ConfigUtil.loadConfig(directory, name, JSON_EXTENSION, gson, defaultValue, write, read);
    }

    public static <T> T loadConfig(Path directory, String name, String extension, Gson gson, T defaultValue, BiConsumer<JsonWriter, T> write, Function<BufferedReader, T> read) throws IOException {
        return (T)ConfigUtil.loadConfig(directory, name, extension, gson, (JsonWriter writer) -> {
            write.accept((JsonWriter)writer, defaultValue);
            return defaultValue;
        }, read);
    }
}

