/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LevelUtil {
    public static HitResult rayTraceServerSide(Entity entity, double range) {
        return LevelUtil.rayTraceServerSide(entity, range, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE);
    }

    public static HitResult rayTraceServerSide(Entity entity, double range, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        Vec3 playerVector = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0);
        Vec3 lookVector = entity.m_20154_();
        Vec3 locationVector = playerVector.m_82520_(lookVector.f_82479_ * range, lookVector.f_82480_ * range, lookVector.f_82481_ * range);
        return entity.f_19853_.m_45547_(new ClipContext(playerVector, locationVector, blockMode, fluidMode, entity));
    }

    public static <T extends SavedData> T getSaveData(ServerLevel level, Function<CompoundTag, T> load, String name, Function<String, T> defaultData) {
        return (T)LevelUtil.getSaveData(level, name, load, () -> (SavedData)defaultData.apply(name));
    }

    public static <T extends SavedData> T getSaveData(ServerLevel level, String name, Function<CompoundTag, T> load, Supplier<T> defaultData) {
        return (T)level.m_8895_().m_164861_(load, defaultData, name);
    }

    public static ServerLevel getServerLevel(Entity entity, ResourceKey<Level> key) {
        return LevelUtil.getServerLevel(entity.m_20194_(), key);
    }

    public static ServerLevel getServerLevel(MinecraftServer server, ResourceKey<Level> key) {
        return server.m_129880_(key);
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> key, BlockPos pos) {
        return LevelUtil.teleportEntity(entity, key, Vec3.m_82512_((Vec3i)pos));
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> key, Vec3 pos) {
        return LevelUtil.teleportEntity(entity, LevelUtil.getServerLevel(entity, key), pos);
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, BlockPos pos) {
        return LevelUtil.teleportEntity(entity, level, Vec3.m_82512_((Vec3i)pos));
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, Vec3 pos) {
        return LevelUtil.teleportEntity(entity, level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), entity.m_146908_(), entity.m_146909_());
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> key, double x, double y, double z, float yaw, float pitch) {
        return LevelUtil.teleportEntity(entity, LevelUtil.getServerLevel(entity, key), x, y, z, yaw, pitch);
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, double x, double y, double z, float yaw, float pitch) {
        return LevelUtil.teleportEntity(entity, level, x, y, z, yaw, pitch, true);
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, double x, double y, double z, float yaw, float pitch, boolean detach) {
        LivingEntity livingEntity;
        float wrapedYaw = Mth.m_14177_((float)yaw);
        float wrapedPitch = Mth.m_14177_((float)pitch);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            level.m_7726_().m_8387_(TicketType.f_9448_, new ChunkPos(new BlockPos(x, y, z)), 1, (Object)entity.m_19879_());
            if (detach) {
                player.m_8127_();
            }
            if (player.m_5803_()) {
                player.m_6145_(true, true);
            }
            if (level == entity.f_19853_) {
                player.f_8906_.m_9774_(x, y, z, wrapedYaw, wrapedPitch);
            } else {
                player.m_8999_(level, x, y, z, wrapedYaw, wrapedPitch);
            }
            entity.m_5616_(wrapedYaw);
        } else {
            float clampedPitch = Mth.m_14036_((float)wrapedPitch, (float)-90.0f, (float)90.0f);
            if (level == entity.f_19853_) {
                entity.m_7678_(x, y, z, wrapedYaw, clampedPitch);
                entity.m_5616_(wrapedYaw);
            } else {
                if (detach) {
                    entity.m_19877_();
                }
                Entity entityOld = entity;
                if ((entity = entity.m_6095_().m_20615_((Level)level)) == null) {
                    return null;
                }
                entity.m_20361_(entityOld);
                entity.m_7678_(x, y, z, wrapedYaw, clampedPitch);
                entity.m_5616_(wrapedYaw);
                entityOld.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                level.m_143334_(entity);
            }
        }
        if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21255_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            entity.m_6853_(true);
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathFinderMob = (PathfinderMob)entity;
            pathFinderMob.m_21573_().m_26573_();
        }
        return entity;
    }
}

