/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextSettingsProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.util.RenderUtil;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class WidgetUtil {
    public static boolean isHovered(AbstractWidget widget) {
        return widget.f_93622_;
    }

    public static <T extends AbstractWidget & BackgroundColorProvider> void renderButtonLikeWidget(T widget, TextureProvider textureProvider, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderUtil.drawContinuousTexturedBox(poseStack, widget.f_93620_, widget.f_93621_, textureProvider.getU(), textureProvider.getV(), widget.f_93618_, widget.f_93619_, textureProvider.getWidth(), textureProvider.getHeight(), 2, 3, 2, 2, widget.m_93252_(), textureProvider.getTexture(), ((BackgroundColorProvider)widget).getCurrentBackgroundColor(poseStack, mouseY, mouseY, partialTicks));
        ((PerspectiveRenderable)widget).renderBackground(poseStack, mouseX, mouseY, partialTicks);
        ((PerspectiveRenderable)widget).renderForeground(poseStack, mouseX, mouseY, partialTicks);
    }

    public static <T extends AbstractWidget> void renderText(T widget, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Font font = ((TextSettingsProvider)widget).getCurrentTextFont();
        Component message = ((TextProvider)widget).getCurrentText();
        if (message != CommonComponents.f_237098_) {
            int messageWidth = font.m_92852_((FormattedText)message);
            int ellipsisWidth = font.m_92895_("...");
            if (messageWidth > widget.f_93618_ - 6 && messageWidth > ellipsisWidth) {
                message = Component.m_237113_((String)(font.m_92854_((FormattedText)message, widget.f_93618_ - 6 - ellipsisWidth).getString() + "..."));
            }
            float xStart = widget.f_93620_ + widget.f_93618_ / 2 - messageWidth / 2;
            float yStart = widget.f_93621_ + (widget.f_93619_ - 8) / 2;
            font.m_92763_(poseStack, message, xStart, yStart, ((TextSettingsProvider)widget).getCurrentTextColor(poseStack, mouseX, mouseY, partialTicks).getColorARGB());
        }
    }

    public static <T extends AbstractWidget & ScaleProvider> void renderScaledText(T widget, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        float scale = ((ScaleProvider)widget).getCurrentScale(poseStack, mouseX, mouseY, partialTicks);
        if (scale == 1.0f) {
            WidgetUtil.renderText(widget, poseStack, mouseX, mouseY, partialTicks);
        } else {
            Font font = ((TextSettingsProvider)widget).getCurrentTextFont();
            Component message = ((TextProvider)widget).getCurrentText();
            if (message != CommonComponents.f_237098_) {
                int messageWidth = Mth.m_14167_((float)(scale * (float)font.m_92852_((FormattedText)message)));
                int ellipsisWidth = Mth.m_14167_((float)(scale * (float)font.m_92895_("...")));
                if (messageWidth > widget.f_93618_ - 6 && messageWidth > ellipsisWidth) {
                    message = Component.m_237113_((String)(font.m_92854_((FormattedText)message, widget.f_93618_ - 6 - ellipsisWidth).getString() + "..."));
                }
                float positionFactor = 1.0f / scale;
                float xStart = (float)(widget.f_93620_ + widget.f_93618_ / 2 - messageWidth / 2) * positionFactor;
                float yStart = (float)(widget.f_93621_ + (int)((float)widget.f_93619_ - 8.0f * scale) / 2) * positionFactor;
                poseStack.m_85836_();
                poseStack.m_85841_(scale, scale, 0.0f);
                font.m_92763_(poseStack, message, xStart, yStart, ((TextSettingsProvider)widget).getCurrentTextColor(poseStack, mouseX, mouseY, partialTicks).getColorARGB());
                poseStack.m_85849_();
            }
        }
    }

    public static void renderTooltips(List<Widget> widgets, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        widgets.forEach(widget -> {
            if (widget instanceof TooltipRenderable) {
                TooltipRenderable tooltipRenderable = (TooltipRenderable)widget;
                tooltipRenderable.renderToolTip(poseStack, mouseX, mouseY, partialTicks);
            }
        });
    }
}

