/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.block_manipulation;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Portal;

public class BlockManipulationClient {
    private static final Minecraft client = Minecraft.m_91087_();
    public static ResourceKey<Level> remotePointedDim;
    public static HitResult remoteHitResult;
    public static boolean isContextSwitched;

    public static boolean isPointingToPortal() {
        return remotePointedDim != null;
    }

    private static BlockHitResult createMissedHitResult(Vec3 from, Vec3 to) {
        Vec3 dir = to.m_82546_(from).m_82541_();
        return BlockHitResult.m_82426_((Vec3)to, (Direction)Direction.m_122366_((double)dir.f_82479_, (double)dir.f_82480_, (double)dir.f_82481_), (BlockPos)new BlockPos(to));
    }

    private static boolean hitResultIsMissedOrNull(HitResult bhr) {
        return bhr == null || bhr.m_6662_() == HitResult.Type.MISS;
    }

    public static void updatePointedBlock(float tickDelta) {
        if (BlockManipulationClient.client.f_91072_ == null || BlockManipulationClient.client.f_91073_ == null || BlockManipulationClient.client.f_91074_ == null) {
            return;
        }
        remotePointedDim = null;
        remoteHitResult = null;
        Vec3 cameraPos = BlockManipulationClient.client.f_91063_.m_109153_().m_90583_();
        float reachDistance = BlockManipulationClient.client.f_91072_.m_105286_();
        PortalCommand.getPlayerPointingPortalRaw((Player)BlockManipulationClient.client.f_91074_, tickDelta, reachDistance, true).ifPresent(pair -> {
            double distanceToPortalPointing;
            Portal portal = (Portal)pair.getFirst();
            if (portal.isInteractable() && portal.isVisible() && (distanceToPortalPointing = ((Vec3)pair.getSecond()).m_82554_(cameraPos)) < BlockManipulationClient.getCurrentTargetDistance() + 0.2) {
                BlockManipulationClient.client.f_91077_ = BlockManipulationClient.createMissedHitResult(cameraPos, (Vec3)pair.getSecond());
                BlockManipulationClient.updateTargetedBlockThroughPortal(cameraPos, BlockManipulationClient.client.f_91074_.m_20252_(tickDelta), (ResourceKey<Level>)BlockManipulationClient.client.f_91074_.f_19853_.m_46472_(), distanceToPortalPointing, reachDistance, portal);
            }
        });
    }

    private static double getCurrentTargetDistance() {
        BlockPos hitPos;
        Vec3 cameraPos = BlockManipulationClient.client.f_91063_.m_109153_().m_90583_();
        if (BlockManipulationClient.hitResultIsMissedOrNull(BlockManipulationClient.client.f_91077_)) {
            return 23333.0;
        }
        if (BlockManipulationClient.client.f_91077_ instanceof BlockHitResult && BlockManipulationClient.client.f_91073_.m_8055_(hitPos = ((BlockHitResult)BlockManipulationClient.client.f_91077_).m_82425_()).m_60734_() == IPRegistry.NETHER_PORTAL_BLOCK.get()) {
            return 23333.0;
        }
        return cameraPos.m_82554_(BlockManipulationClient.client.f_91077_.m_82450_());
    }

    private static void updateTargetedBlockThroughPortal(Vec3 cameraPos, Vec3 viewVector, ResourceKey<Level> playerDimension, double beginDistance, double endDistance, Portal portal) {
        Vec3 from = portal.transformPoint(cameraPos.m_82549_(viewVector.m_82490_(beginDistance)));
        Vec3 to = portal.transformPoint(cameraPos.m_82549_(viewVector.m_82490_(endDistance)));
        ClipContext context = new ClipContext(from, to, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)BlockManipulationClient.client.f_91074_);
        ClientLevel world = ClientWorldLoader.getWorld(portal.dimensionTo);
        remoteHitResult = (HitResult)BlockGetter.m_151361_((Vec3)from, (Vec3)to, (Object)context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.m_8055_(blockPos);
            if (blockState.m_60734_() == IPRegistry.NETHER_PORTAL_BLOCK.get()) {
                return null;
            }
            if (blockState.m_60734_() == Blocks.f_50375_) {
                return null;
            }
            FluidState fluidState = world.m_6425_(blockPos);
            Vec3 start = rayTraceContext.m_45702_();
            Vec3 end = rayTraceContext.m_45693_();
            Vec3 correctedStart = start.m_82546_(end.m_82546_(start).m_82490_(0.0015));
            VoxelShape solidShape = rayTraceContext.m_45694_(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockHitResult = world.m_45558_(correctedStart, end, blockPos, solidShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidHitResult = fluidShape.m_83220_(start, end, blockPos);
            double d = blockHitResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockHitResult.m_82450_());
            double e = fluidHitResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidHitResult.m_82450_());
            return d <= e ? blockHitResult : fluidHitResult;
        }, rayTraceContext -> {
            Vec3 vec3d = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)vec3d.f_82479_, (double)vec3d.f_82480_, (double)vec3d.f_82481_), (BlockPos)new BlockPos(rayTraceContext.m_45693_()));
        });
        if (BlockManipulationClient.remoteHitResult.m_82450_().f_82480_ < (double)world.m_141937_() + 0.1) {
            remoteHitResult = new BlockHitResult(remoteHitResult.m_82450_(), Direction.DOWN, ((BlockHitResult)remoteHitResult).m_82425_(), ((BlockHitResult)remoteHitResult).m_82436_());
        }
        if (remoteHitResult != null && !world.m_8055_(((BlockHitResult)remoteHitResult).m_82425_()).m_60795_()) {
            BlockManipulationClient.client.f_91077_ = BlockManipulationClient.createMissedHitResult(from, to);
            remotePointedDim = portal.dimensionTo;
        }
    }

    public static void myHandleBlockBreaking(boolean isKeyPressed) {
        if (!BlockManipulationClient.client.f_91074_.m_6117_()) {
            if (isKeyPressed && BlockManipulationClient.isPointingToPortal()) {
                Direction direction;
                BlockHitResult blockHitResult = (BlockHitResult)remoteHitResult;
                BlockPos blockPos = blockHitResult.m_82425_();
                ClientLevel remoteWorld = ClientWorldLoader.getWorld(remotePointedDim);
                if (!remoteWorld.m_8055_(blockPos).m_60795_() && BlockManipulationClient.myUpdateBlockBreakingProgress(blockPos, direction = blockHitResult.m_82434_())) {
                    BlockManipulationClient.client.f_91061_.m_107367_(blockPos, direction);
                    BlockManipulationClient.client.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                }
            } else {
                BlockManipulationClient.client.f_91072_.m_105276_();
            }
        }
    }

    public static boolean myUpdateBlockBreakingProgress(BlockPos blockPos, Direction direction) {
        ClientLevel targetWorld = ClientWorldLoader.getWorld(remotePointedDim);
        return BlockManipulationClient.withWorldSwitchedAndPlayerDimensionSwitched(targetWorld, () -> BlockManipulationClient.client.f_91072_.m_105283_(blockPos, direction));
    }

    public static boolean myAttackBlock() {
        BlockPos blockPos;
        ClientLevel targetWorld = ClientWorldLoader.getWorld(remotePointedDim);
        if (targetWorld.m_46859_(blockPos = ((BlockHitResult)remoteHitResult).m_82425_())) {
            return true;
        }
        return BlockManipulationClient.withWorldSwitchedAndPlayerDimensionSwitched(targetWorld, () -> {
            BlockManipulationClient.client.f_91072_.m_105269_(blockPos, ((BlockHitResult)remoteHitResult).m_82434_());
            BlockManipulationClient.client.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
            return BlockManipulationClient.client.f_91073_.m_8055_(blockPos).m_60795_();
        });
    }

    public static void myItemUse(InteractionHand hand) {
        InteractionResult actionResult3;
        ClientLevel targetWorld = ClientWorldLoader.getWorld(remotePointedDim);
        ItemStack itemStack = BlockManipulationClient.client.f_91074_.m_21120_(hand);
        BlockHitResult blockHitResult = (BlockHitResult)remoteHitResult;
        Tuple<BlockHitResult, ResourceKey<Level>> result = BlockManipulationServer.getHitResultForPlacing((Level)targetWorld, blockHitResult);
        blockHitResult = (BlockHitResult)result.m_14418_();
        targetWorld = ClientWorldLoader.getWorld((ResourceKey<Level>)((ResourceKey)result.m_14419_()));
        remoteHitResult = blockHitResult;
        remotePointedDim = (ResourceKey)result.m_14419_();
        int count = itemStack.m_41613_();
        InteractionResult actionResult2 = BlockManipulationClient.myInteractBlock(hand, targetWorld, blockHitResult);
        if (actionResult2.m_19077_()) {
            if (actionResult2.m_19080_()) {
                BlockManipulationClient.client.f_91074_.m_6674_(hand);
                if (!itemStack.m_41619_() && (itemStack.m_41613_() != count || BlockManipulationClient.client.f_91072_.m_105290_())) {
                    BlockManipulationClient.client.f_91063_.f_109055_.m_109320_(hand);
                }
            }
            return;
        }
        if (actionResult2 == InteractionResult.FAIL) {
            return;
        }
        if (!itemStack.m_41619_() && (actionResult3 = BlockManipulationClient.withWorldSwitchedAndPlayerDimensionSwitched(targetWorld, () -> BlockManipulationClient.client.f_91072_.m_233721_((Player)BlockManipulationClient.client.f_91074_, hand))).m_19077_()) {
            if (actionResult3.m_19080_()) {
                BlockManipulationClient.client.f_91074_.m_6674_(hand);
            }
            BlockManipulationClient.client.f_91063_.f_109055_.m_109320_(hand);
            return;
        }
    }

    private static InteractionResult myInteractBlock(InteractionHand hand, ClientLevel targetWorld, BlockHitResult blockHitResult) {
        return BlockManipulationClient.withWorldSwitchedAndPlayerDimensionSwitched(targetWorld, () -> BlockManipulationClient.client.f_91072_.m_233732_(BlockManipulationClient.client.f_91074_, hand, blockHitResult));
    }

    private static <T> T withWorldSwitchedAndPlayerDimensionSwitched(ClientLevel targetWorld, Supplier<T> supplier) {
        return (T)IPMcHelper.withSwitchedContext((Level)targetWorld, () -> {
            Level oldWorld = BlockManipulationClient.client.f_91074_.f_19853_;
            isContextSwitched = true;
            BlockManipulationClient.client.f_91074_.f_19853_ = targetWorld;
            try {
                Object t = supplier.get();
                return t;
            }
            finally {
                isContextSwitched = false;
                BlockManipulationClient.client.f_91074_.f_19853_ = oldWorld;
            }
        });
    }

    static {
        isContextSwitched = false;
    }
}

