/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.ChunkVisibility;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.MyLoadingTicket;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.miscellaneous.GcMonitor;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.SignalBiArged;

public class NewChunkTrackingGraph {
    public static final int updateInterval = 40;
    private static final Map<ResourceKey<Level>, Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>>> data = new HashMap<ResourceKey<Level>, Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>>>();
    private static final ArrayList<WeakReference<ChunkLoader>> additionalChunkLoaders = new ArrayList();
    private static final WeakHashMap<ServerPlayer, PlayerInfo> playerInfoMap = new WeakHashMap();
    public static final SignalBiArged<ServerPlayer, DimensionalChunkPos> beginWatchChunkSignal = new SignalBiArged();
    public static final SignalBiArged<ServerPlayer, DimensionalChunkPos> endWatchChunkSignal = new SignalBiArged();
    public static final SignalBiArged<ResourceKey<Level>, Long> watchStatusChangeSignal = new SignalBiArged();
    private static final Random random = new Random();

    private static void removeInactiveWatchers(ArrayList<PlayerWatchRecord> records, Predicate<PlayerWatchRecord> predicate, Consumer<PlayerWatchRecord> informer) {
        records.removeIf(r -> {
            Validate.isTrue((boolean)r.isValid);
            boolean shouldRemove = predicate.test((PlayerWatchRecord)r);
            if (shouldRemove) {
                informer.accept((PlayerWatchRecord)r);
                r.isValid = false;
            }
            return shouldRemove;
        });
    }

    private static boolean shouldAddCustomTicket(ServerLevel world, long chunkPos, ArrayList<PlayerWatchRecord> records) {
        boolean isIndirectLoading = Helper.indexOf(records, r -> r.isLoadedToPlayer && !r.isDirectLoading) != -1;
        return isIndirectLoading;
    }

    private static Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>> getChunkRecordMap(ResourceKey<Level> dimension) {
        return data.computeIfAbsent(dimension, k -> new Long2ObjectLinkedOpenHashMap());
    }

    public static PlayerInfo getPlayerInfo(ServerPlayer player) {
        return playerInfoMap.computeIfAbsent(player, k -> new PlayerInfo());
    }

    public static void updateForPlayer(ServerPlayer player) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        playerInfo.visibleDimensions.clear();
        long gameTime = McHelper.getOverWorldOnServer().m_46467_();
        ChunkVisibility.getBaseChunkLoaders(player).forEach(chunkLoader -> NewChunkTrackingGraph.updatePlayerForChunkLoader(player, gameTime, chunkLoader, playerInfo));
        playerInfo.additionalChunkLoaders.forEach(l -> {
            ChunkLoader chunkLoader = l;
            Validate.notNull((Object)chunkLoader);
            NewChunkTrackingGraph.updatePlayerForChunkLoader(player, gameTime, chunkLoader, playerInfo);
        });
    }

    public static void flushPendingLoading(ServerPlayer player) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        int limit = NewChunkTrackingGraph.getChunkDeliveringLimitPerTick(player);
        int loaded = 0;
        int directLoaded = 0;
        for (int distance = 0; distance < playerInfo.distanceToPendingChunks.size(); ++distance) {
            ArrayDeque<PlayerWatchRecord> records = playerInfo.distanceToPendingChunks.get(distance);
            if (records == null) continue;
            while (!records.isEmpty() && loaded < limit && directLoaded < 5) {
                PlayerWatchRecord record = records.pollFirst();
                if (!record.isValid || record.isLoadedToPlayer) continue;
                record.isLoadedToPlayer = true;
                if (MiscHelper.getServer().m_129880_(record.dimension) != null) {
                    beginWatchChunkSignal.emit(player, new DimensionalChunkPos(record.dimension, new ChunkPos(record.chunkPos)));
                    if (!record.isDirectLoading) {
                        MyLoadingTicket.addTicketIfNotLoaded(McHelper.getServerWorld(record.dimension), new ChunkPos(record.chunkPos));
                    }
                    watchStatusChangeSignal.emit(record.dimension, record.chunkPos);
                    if (!record.isDirectLoading) {
                        ++loaded;
                        continue;
                    }
                    ++directLoaded;
                    continue;
                }
                Helper.err("Missing dimension when flushing pending loading " + record.dimension.m_135782_());
            }
        }
    }

    private static int getChunkDeliveringLimitPerTick(ServerPlayer player) {
        if (player.f_19797_ < 100) {
            return 200;
        }
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        if (playerInfo.performanceLevel == PerformanceLevel.good) {
            return 5;
        }
        if (playerInfo.performanceLevel == PerformanceLevel.medium) {
            return 1;
        }
        return player.f_19797_ % 4 == 0 ? 1 : 0;
    }

    private static void updatePlayerForChunkLoader(ServerPlayer player, long gameTime, ChunkLoader chunkLoader, PlayerInfo playerInfo) {
        ResourceKey<Level> chunkLoaderDim = chunkLoader.center.dimension;
        playerInfo.visibleDimensions.add(chunkLoaderDim);
        Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>> chunkRecordMap = NewChunkTrackingGraph.getChunkRecordMap(chunkLoaderDim);
        chunkLoader.foreachChunkPos((dimension, x, z, distanceToSource) -> {
            long chunkPos = ChunkPos.m_45589_((int)x, (int)z);
            ArrayList records = (ArrayList)chunkRecordMap.computeIfAbsent(chunkPos, k -> new ArrayList());
            int index = Helper.indexOf(records, r -> r.player == player);
            if (index == -1) {
                PlayerWatchRecord newRecord = new PlayerWatchRecord(player, (ResourceKey<Level>)dimension, chunkPos, gameTime, distanceToSource, chunkLoader.isDirectLoader, false);
                records.add(newRecord);
                playerInfo.markPendingLoading(newRecord);
            } else {
                PlayerWatchRecord record = (PlayerWatchRecord)records.get(index);
                if (record.lastWatchTime == gameTime) {
                    int oldDistance = record.distanceToSource;
                    if (distanceToSource < oldDistance) {
                        record.distanceToSource = distanceToSource;
                        playerInfo.markPendingLoading(record);
                    }
                    record.isDirectLoading |= chunkLoader.isDirectLoader;
                } else {
                    int oldDistance = record.distanceToSource;
                    if (distanceToSource < oldDistance) {
                        playerInfo.markPendingLoading(record);
                    }
                    record.distanceToSource = distanceToSource;
                    record.lastWatchTime = gameTime;
                    record.isDirectLoading = chunkLoader.isDirectLoader;
                }
            }
        });
    }

    private static void updateAndPurge() {
        long currTime = McHelper.getOverWorldOnServer().m_46467_();
        data.forEach((dimension, chunkRecords) -> chunkRecords.long2ObjectEntrySet().removeIf(entry -> {
            long chunkPosLong = entry.getLongKey();
            ArrayList records = (ArrayList)entry.getValue();
            NewChunkTrackingGraph.removeInactiveWatchers(records, record -> NewChunkTrackingGraph.shouldUnload(currTime, record), record -> {
                if (record.player.m_213877_()) {
                    return;
                }
                if (record.isLoadedToPlayer) {
                    endWatchChunkSignal.emit(record.player, new DimensionalChunkPos((ResourceKey<Level>)dimension, ChunkPos.m_45592_((long)chunkPosLong), ChunkPos.m_45602_((long)chunkPosLong)));
                }
                watchStatusChangeSignal.emit(record.dimension, record.chunkPos);
            });
            return records.isEmpty();
        }));
        MiscHelper.getServer().m_129785_().forEach(world -> {
            Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>> chunkRecordMap = NewChunkTrackingGraph.getChunkRecordMap((ResourceKey<Level>)world.m_46472_());
            LongLinkedOpenHashSet additionalLoadedChunks = new LongLinkedOpenHashSet();
            additionalChunkLoaders.forEach((Consumer<WeakReference<ChunkLoader>>)((Consumer<WeakReference>)arg_0 -> NewChunkTrackingGraph.lambda$updateAndPurge$14(world, (LongSortedSet)additionalLoadedChunks, arg_0)));
            additionalChunkLoaders.removeIf(ref -> ref.get() == null);
            LongArrayList chunksToUnload = new LongArrayList();
            MyLoadingTicket.getRecord(world).forEach(arg_0 -> NewChunkTrackingGraph.lambda$updateAndPurge$16(chunkRecordMap, (LongSortedSet)additionalLoadedChunks, (LongList)chunksToUnload, arg_0));
            chunksToUnload.forEach(longChunkPos -> MyLoadingTicket.removeTicketIfPresent(world, new ChunkPos(longChunkPos)));
        });
        playerInfoMap.entrySet().removeIf(e -> ((ServerPlayer)e.getKey()).m_213877_());
    }

    private static boolean shouldUnload(long currTime, PlayerWatchRecord record) {
        if (record.player.m_213877_()) {
            return true;
        }
        long unloadDelay = IPGlobal.chunkUnloadDelayTicks;
        if (unloadDelay < 41L) {
            unloadDelay = 41L;
        }
        if (GcMonitor.isMemoryNotEnough()) {
            unloadDelay = 41L;
        }
        return currTime - record.lastWatchTime > unloadDelay;
    }

    private static void tick() {
        MiscHelper.getServer().m_129905_().m_6180_("portal_chunk_tracking");
        long gameTime = McHelper.getOverWorldOnServer().m_46467_();
        McHelper.getCopiedPlayerList().forEach(player -> {
            if ((long)(player.m_19879_() % 40) == gameTime % 40L) {
                NewChunkTrackingGraph.updateForPlayer(player);
            }
            NewChunkTrackingGraph.flushPendingLoading(player);
        });
        if (gameTime % 40L == 0L) {
            NewChunkTrackingGraph.updateAndPurge();
        }
        MiscHelper.getServer().m_129905_().m_7238_();
    }

    public static void init() {
        IPGlobal.postServerTickSignal.connect(NewChunkTrackingGraph::tick);
        IPGlobal.serverCleanupSignal.connect(NewChunkTrackingGraph::cleanup);
    }

    public static boolean isPlayerWatchingChunk(ServerPlayer player, ResourceKey<Level> dimension, int x, int z, Predicate<PlayerWatchRecord> predicate) {
        long chunkPos = ChunkPos.m_45589_((int)x, (int)z);
        ArrayList recordMap = (ArrayList)NewChunkTrackingGraph.getChunkRecordMap(dimension).get(chunkPos);
        if (recordMap == null) {
            return false;
        }
        int i = Helper.indexOf(recordMap, r -> r.player == player);
        if (i == -1) {
            return false;
        }
        PlayerWatchRecord record = (PlayerWatchRecord)recordMap.get(i);
        if (!record.isLoadedToPlayer) {
            return false;
        }
        return predicate.test(record);
    }

    public static boolean isPlayerWatchingChunk(ServerPlayer player, ResourceKey<Level> dimension, int x, int z) {
        return NewChunkTrackingGraph.isPlayerWatchingChunk(player, dimension, x, z, r -> true);
    }

    public static boolean isPlayerWatchingChunkWithinRaidus(ServerPlayer player, ResourceKey<Level> dimension, int x, int z, int radiusBlocks) {
        boolean result = NewChunkTrackingGraph.isPlayerWatchingChunk(player, dimension, x, z, r -> r.distanceToSource * 16 <= radiusBlocks);
        return result;
    }

    private static void cleanup() {
        data.clear();
        additionalChunkLoaders.clear();
    }

    public static Stream<ServerPlayer> getPlayersViewingChunk(ResourceKey<Level> dimension, int x, int z) {
        ArrayList records = (ArrayList)NewChunkTrackingGraph.getChunkRecordMap(dimension).get(ChunkPos.m_45589_((int)x, (int)z));
        if (records == null) {
            return Stream.empty();
        }
        return records.stream().filter(r -> r.isLoadedToPlayer).map(r -> r.player);
    }

    public static int getMinimumWatchingDistance(ResourceKey<Level> dimension, long chunkPos) {
        ArrayList records = (ArrayList)NewChunkTrackingGraph.getChunkRecordMap(dimension).get(chunkPos);
        if (records == null) {
            return -1;
        }
        return records.stream().filter(r -> r.isLoadedToPlayer).mapToInt(r -> r.distanceToSource).min().orElse(-1);
    }

    public static Stream<ServerPlayer> getFarWatchers(ResourceKey<Level> dimension, int x, int z) {
        return NewChunkTrackingGraph.getPlayersViewingChunk(dimension, x, z).filter(player -> {
            ChunkPos chunkPos = player.m_146902_();
            return player.f_19853_.m_46472_() != dimension || Helper.getChebyshevDistance(x, z, chunkPos.f_45578_, chunkPos.f_45579_) > 4;
        });
    }

    public static void forceRemovePlayer(ServerPlayer player) {
        data.forEach((dim, map) -> map.forEach((chunkPos, records) -> NewChunkTrackingGraph.removeInactiveWatchers(records, r -> r.player == player, record -> {
            record.isValid = false;
            PacketRedirection.sendRedirectedMessage(record.player, (ResourceKey<Level>)dim, (Packet)new ClientboundForgetLevelChunkPacket(ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos)));
        })));
    }

    public static void forceRemoveDimension(ResourceKey<Level> dim) {
        Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>> map = data.get(dim);
        if (map == null) {
            return;
        }
        map.forEach((chunkPos, records) -> {
            Packet<ClientGamePacketListener> unloadPacket = PacketRedirection.createRedirectedMessage(dim, (Packet<ClientGamePacketListener>)new ClientboundForgetLevelChunkPacket(ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos)));
            for (PlayerWatchRecord record : records) {
                if (record.isValid && record.isLoadedToPlayer) {
                    record.player.f_8906_.m_9829_(unloadPacket);
                }
                record.isValid = false;
            }
        });
        data.remove(dim);
        additionalChunkLoaders.removeIf(l -> {
            ChunkLoader chunkLoader = (ChunkLoader)l.get();
            return chunkLoader != null && chunkLoader.center.dimension == dim;
        });
        for (PlayerInfo playerInfo : playerInfoMap.values()) {
            playerInfo.additionalChunkLoaders.removeIf(l -> l.center.dimension == dim);
        }
    }

    public static boolean shouldLoadDimension(ResourceKey<Level> dimension) {
        if (!data.containsKey(dimension)) {
            return false;
        }
        Long2ObjectLinkedOpenHashMap<ArrayList<PlayerWatchRecord>> map = data.get(dimension);
        return !map.isEmpty();
    }

    public static void addGlobalAdditionalChunkLoader(ChunkLoader chunkLoader) {
        additionalChunkLoaders.add(new WeakReference<ChunkLoader>(chunkLoader));
        NewChunkTrackingGraph.updateAndPurge();
    }

    public static void removeGlobalAdditionalChunkLoader(ChunkLoader chunkLoader) {
        additionalChunkLoaders.removeIf(weakRef -> weakRef.get() == chunkLoader);
    }

    public static void addAdditionalDirectLoadingTickets(ServerPlayer player) {
        ChunkVisibility.playerDirectLoader(player).foreachChunkPos((dim, x, z, dis) -> {
            if (NewChunkTrackingGraph.isPlayerWatchingChunk(player, (ResourceKey<Level>)dim, x, z)) {
                MyLoadingTicket.addTicketIfNotLoaded((ServerLevel)player.f_19853_, new ChunkPos(x, z));
            }
        });
    }

    public static int getLoadedChunkNum(ResourceKey<Level> dimension) {
        return NewChunkTrackingGraph.getChunkRecordMap(dimension).size();
    }

    public static void addPerPlayerAdditionalChunkLoader(ServerPlayer player, ChunkLoader chunkLoader) {
        NewChunkTrackingGraph.getPlayerInfo((ServerPlayer)player).additionalChunkLoaders.add(chunkLoader);
    }

    public static void removePerPlayerAdditionalChunkLoader(ServerPlayer player, ChunkLoader chunkLoader) {
        NewChunkTrackingGraph.getPlayerInfo((ServerPlayer)player).additionalChunkLoaders.remove(chunkLoader);
    }

    public static Set<ResourceKey<Level>> getVisibleDimensions(ServerPlayer player) {
        return NewChunkTrackingGraph.getPlayerInfo((ServerPlayer)player).visibleDimensions;
    }

    private static /* synthetic */ void lambda$updateAndPurge$16(Long2ObjectLinkedOpenHashMap chunkRecordMap, LongSortedSet additionalLoadedChunks, LongList chunksToUnload, long longChunkPos) {
        if (!chunkRecordMap.containsKey(longChunkPos) && !additionalLoadedChunks.contains(longChunkPos)) {
            chunksToUnload.add(longChunkPos);
        }
    }

    private static /* synthetic */ void lambda$updateAndPurge$14(ServerLevel world, LongSortedSet additionalLoadedChunks, WeakReference weakRef) {
        ChunkLoader loader = (ChunkLoader)weakRef.get();
        if (loader == null) {
            return;
        }
        loader.foreachChunkPos((dim, x, z, dis) -> {
            if (world.m_46472_() == dim) {
                additionalLoadedChunks.add(ChunkPos.m_45589_((int)x, (int)z));
                MyLoadingTicket.addTicketIfNotLoaded(world, new ChunkPos(x, z));
                watchStatusChangeSignal.emit((ResourceKey<Level>)dim, ChunkPos.m_45589_((int)x, (int)z));
            }
        });
    }

    public static class PlayerInfo {
        public final Set<ResourceKey<Level>> visibleDimensions = new HashSet<ResourceKey<Level>>();
        public final ArrayList<ChunkLoader> additionalChunkLoaders = new ArrayList();
        public final ArrayList<ArrayDeque<PlayerWatchRecord>> distanceToPendingChunks = new ArrayList();
        public PerformanceLevel performanceLevel = PerformanceLevel.bad;

        public void markPendingLoading(PlayerWatchRecord record) {
            Helper.arrayListComputeIfAbsent(this.distanceToPendingChunks, record.distanceToSource, ArrayDeque::new).add(record);
        }
    }

    public static class PlayerWatchRecord {
        public final ServerPlayer player;
        public final ResourceKey<Level> dimension;
        public final long chunkPos;
        public long lastWatchTime;
        public int distanceToSource;
        public boolean isDirectLoading;
        public boolean isLoadedToPlayer;
        public boolean isValid = true;

        public PlayerWatchRecord(ServerPlayer player, ResourceKey<Level> dimension, long chunkPos, long lastWatchTime, int distanceToSource, boolean isDirectLoading, boolean isLoadedToPlayer) {
            this.player = player;
            this.dimension = dimension;
            this.chunkPos = chunkPos;
            this.lastWatchTime = lastWatchTime;
            this.distanceToSource = distanceToSource;
            this.isDirectLoading = isDirectLoading;
            this.isLoadedToPlayer = isLoadedToPlayer;
        }

        public String toString() {
            return String.format("%s (%d,%d) distance:%d valid:%s loaded:%s", this.dimension.m_135782_(), ChunkPos.m_45592_((long)this.chunkPos), ChunkPos.m_45602_((long)this.chunkPos), this.distanceToSource, this.isValid, this.isLoadedToPlayer);
        }
    }

    public static class RemoteCallables {
        public static void acceptClientPerformanceInfo(ServerPlayer player, PerformanceLevel performanceLevel) {
            PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
            playerInfo.performanceLevel = performanceLevel;
        }
    }
}

