/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat.iris_compatibility;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.compat.IPPortingLibCompat;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.SecondaryFrameBuffer;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;

public class IrisCompatibilityPortalRenderer
extends PortalRenderer {
    public static final IrisCompatibilityPortalRenderer instance = new IrisCompatibilityPortalRenderer(false);
    public static final IrisCompatibilityPortalRenderer debugModeInstance = new IrisCompatibilityPortalRenderer(true);
    private SecondaryFrameBuffer deferredBuffer = new SecondaryFrameBuffer();
    private PoseStack modelView = new PoseStack();
    public boolean isDebugMode;

    public IrisCompatibilityPortalRenderer(boolean isDebugMode) {
        this.isDebugMode = isDebugMode;
    }

    @Override
    public boolean replaceFrameBufferClearing() {
        client.m_91385_().m_83947_(false);
        return false;
    }

    @Override
    public void onBeforeTranslucentRendering(PoseStack matrixStack) {
        if (PortalRendering.isRendering()) {
            return;
        }
        this.modelView = new PoseStack();
        this.modelView.m_85836_();
        this.modelView.m_85850_().m_85861_().m_27644_(matrixStack.m_85850_().m_85861_());
        this.modelView.m_85850_().m_85864_().m_8178_(matrixStack.m_85850_().m_85864_());
        GL11.glDisable((int)2960);
    }

    @Override
    public void onAfterTranslucentRendering(PoseStack matrixStack) {
    }

    @Override
    public void finishRendering() {
        GL11.glDisable((int)2960);
    }

    @Override
    public void prepareRendering() {
        this.deferredBuffer.prepare();
        this.deferredBuffer.fb.m_83931_(1.0f, 0.0f, 0.0f, 0.0f);
        this.deferredBuffer.fb.m_83954_(Minecraft.f_91002_);
        IPPortingLibCompat.setIsStencilEnabled(client.m_91385_(), false);
        client.m_91385_().m_83947_(false);
    }

    protected void doRenderPortal(PortalLike portal, PoseStack matrixStack) {
        if (PortalRendering.isRendering()) {
            return;
        }
        if (!this.testShouldRenderPortal(portal, matrixStack)) {
            return;
        }
        client.m_91385_().m_83947_(true);
        PortalRendering.pushPortalLayer(portal);
        this.renderPortalContent(portal);
        PortalRendering.popPortalLayer();
        CHelper.enableDepthClamp();
        if (!this.isDebugMode) {
            this.deferredBuffer.fb.m_83947_(true);
            MyRenderHelper.drawPortalAreaWithFramebuffer(portal, client.m_91385_(), matrixStack.m_85850_().m_85861_(), RenderSystem.m_157192_());
        } else {
            this.deferredBuffer.fb.m_83947_(true);
            MyRenderHelper.drawScreenFrameBuffer(client.m_91385_(), true, true);
        }
        CHelper.disableDepthClamp();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        client.m_91385_().m_83947_(true);
    }

    @Override
    public void invokeWorldRendering(WorldRenderInfo worldRenderInfo) {
        MyGameRenderer.renderWorldNew(worldRenderInfo, Runnable::run);
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    private boolean testShouldRenderPortal(PortalLike portal, PoseStack matrixStack) {
        this.deferredBuffer.fb.m_83947_(true);
        return PortalRenderInfo.renderAndDecideVisibility(portal, () -> ViewAreaRenderer.renderPortalArea(portal, Vec3.f_82478_, matrixStack.m_85850_().m_85861_(), RenderSystem.m_157192_(), true, false, false));
    }

    @Override
    public void onBeforeHandRendering(PoseStack matrixStack) {
        if (PortalRendering.isRendering()) {
            return;
        }
        CHelper.checkGlError();
        GL30.glBindFramebuffer((int)36008, (int)IrisCompatibilityPortalRenderer.client.m_91385_().f_83920_);
        GL30.glBindFramebuffer((int)36009, (int)this.deferredBuffer.fb.f_83920_);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.deferredBuffer.fb.f_83915_, (int)this.deferredBuffer.fb.f_83916_, (int)0, (int)0, (int)this.deferredBuffer.fb.f_83915_, (int)this.deferredBuffer.fb.f_83916_, (int)16640, (int)9728);
        CHelper.checkGlError();
        this.renderPortals(this.modelView);
        this.modelView.m_85849_();
        RenderTarget mainFrameBuffer = client.m_91385_();
        mainFrameBuffer.m_83947_(true);
        MyRenderHelper.drawScreenFrameBuffer((RenderTarget)this.deferredBuffer.fb, false, false);
    }

    @Override
    public void onHandRenderingEnded(PoseStack matrixStack) {
    }

    protected void renderPortals(PoseStack matrixStack) {
        List<PortalLike> portalsToRender = this.getPortalsToRender(matrixStack);
        for (PortalLike portal : portalsToRender) {
            this.doRenderPortal(portal, matrixStack);
        }
    }
}

