/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat.iris_compatibility;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.IPPortingLibCompat;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.SecondaryFrameBuffer;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;

public class IrisPortalRenderer
extends PortalRenderer {
    public static final IrisPortalRenderer instance = new IrisPortalRenderer();
    private SecondaryFrameBuffer[] deferredFbs = new SecondaryFrameBuffer[0];
    private boolean portalRenderingNeeded = false;
    private boolean nextFramePortalRenderingNeeded = false;

    IrisPortalRenderer() {
        IPGlobal.preGameRenderSignal.connect(() -> this.updateNeedsPortalRendering());
    }

    @Override
    public boolean replaceFrameBufferClearing() {
        return false;
    }

    @Override
    public void prepareRendering() {
        Validate.isTrue((!PortalRendering.isRendering() ? 1 : 0) != 0);
        if (this.deferredFbs.length != PortalRendering.getMaxPortalLayer() + 1) {
            for (SecondaryFrameBuffer fb : this.deferredFbs) {
                fb.fb.m_83930_();
            }
            this.deferredFbs = new SecondaryFrameBuffer[PortalRendering.getMaxPortalLayer() + 1];
            for (int i = 0; i < this.deferredFbs.length; ++i) {
                this.deferredFbs[i] = new SecondaryFrameBuffer();
            }
        }
        CHelper.checkGlError();
        for (SecondaryFrameBuffer deferredFb : this.deferredFbs) {
            deferredFb.prepare();
            IPPortingLibCompat.setIsStencilEnabled((RenderTarget)deferredFb.fb, true);
            deferredFb.fb.m_83947_(true);
            GlStateManager.m_84318_((float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.m_84121_((double)1.0);
            GlStateManager.m_84553_((int)0);
            GL11.glClear((int)17664);
            deferredFb.fb.m_83949_();
            CHelper.checkGlError();
            deferredFb.fb.m_83970_();
        }
        IPPortingLibCompat.setIsStencilEnabled(client.m_91385_(), false);
        client.m_91385_().m_83947_(false);
    }

    private void updateNeedsPortalRendering() {
        this.portalRenderingNeeded = this.nextFramePortalRenderingNeeded;
        this.nextFramePortalRenderingNeeded = false;
    }

    @Override
    public void onBeforeHandRendering(PoseStack matrixStack) {
        this.doMainRenderings(matrixStack);
    }

    private void doMainRenderings(PoseStack matrixStack) {
        CHelper.checkGlError();
        RenderTarget mcFrameBuffer = client.m_91385_();
        int portalLayer = PortalRendering.getPortalLayer();
        if (this.portalRenderingNeeded) {
            CHelper.doCheckGlError();
            GL30.glBindFramebuffer((int)36008, (int)mcFrameBuffer.f_83920_);
            GL30.glBindFramebuffer((int)36009, (int)this.deferredFbs[portalLayer].fb.f_83920_);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)mcFrameBuffer.f_83917_, (int)mcFrameBuffer.f_83918_, (int)0, (int)0, (int)mcFrameBuffer.f_83917_, (int)mcFrameBuffer.f_83918_, (int)256, (int)9728);
            int errorCode = GL11.glGetError();
            if (errorCode != 0) {
                IPGlobal.renderMode = IPGlobal.RenderMode.compatibility;
                CHelper.printChat("[Immersive Portals]Switched to compatibility portal rendering mode. Portal-in-portal wont' be rendered");
            }
            this.initStencilForLayer(portalLayer);
            this.deferredFbs[portalLayer].fb.m_83947_(true);
            GL11.glEnable((int)2960);
            GL11.glStencilFunc((int)514, (int)portalLayer, (int)255);
            GL11.glStencilOp((int)7680, (int)7680, (int)7680);
            MyRenderHelper.drawScreenFrameBuffer(mcFrameBuffer, false, true);
            GL11.glDisable((int)2960);
            this.deferredFbs[portalLayer].fb.m_83970_();
            mcFrameBuffer.m_83947_(false);
        }
        this.renderPortals(matrixStack);
        if (portalLayer == 0) {
            this.finish();
        }
        mcFrameBuffer.m_83947_(true);
    }

    @Override
    public void onHandRenderingEnded(PoseStack matrixStack) {
    }

    private void initStencilForLayer(int portalLayer) {
        if (portalLayer == 0) {
            this.deferredFbs[portalLayer].fb.m_83947_(true);
            GlStateManager.m_84553_((int)0);
            GL11.glClear((int)1024);
        } else {
            CHelper.checkGlError();
            GL30.glBindFramebuffer((int)36008, (int)this.deferredFbs[portalLayer - 1].fb.f_83920_);
            GL30.glBindFramebuffer((int)36009, (int)this.deferredFbs[portalLayer].fb.f_83920_);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)this.deferredFbs[0].fb.f_83917_, (int)this.deferredFbs[0].fb.f_83918_, (int)0, (int)0, (int)this.deferredFbs[0].fb.f_83917_, (int)this.deferredFbs[0].fb.f_83918_, (int)1024, (int)9728);
            CHelper.checkGlError();
        }
    }

    @Override
    public void onBeforeTranslucentRendering(PoseStack matrixStack) {
    }

    @Override
    public void onAfterTranslucentRendering(PoseStack matrixStack) {
    }

    @Override
    public void finishRendering() {
    }

    private void finish() {
        GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (RenderStates.getRenderedPortalNum() == 0) {
            return;
        }
        if (!this.portalRenderingNeeded) {
            return;
        }
        RenderTarget mainFrameBuffer = client.m_91385_();
        mainFrameBuffer.m_83947_(true);
        this.deferredFbs[0].fb.m_83938_(mainFrameBuffer.f_83917_, mainFrameBuffer.f_83918_);
        CHelper.checkGlError();
    }

    protected void doRenderPortal(PortalLike portal, PoseStack matrixStack) {
        this.nextFramePortalRenderingNeeded = true;
        if (!this.portalRenderingNeeded) {
            return;
        }
        if (!this.tryRenderViewAreaInDeferredBufferAndIncreaseStencil(portal, matrixStack)) {
            return;
        }
        PortalRendering.pushPortalLayer(portal);
        client.m_91385_().m_83947_(true);
        this.renderPortalContent(portal);
        int innerLayer = PortalRendering.getPortalLayer();
        PortalRendering.popPortalLayer();
        int outerLayer = PortalRendering.getPortalLayer();
        if (innerLayer > PortalRendering.getMaxPortalLayer()) {
            return;
        }
        this.deferredFbs[outerLayer].fb.m_83947_(true);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)514, (int)innerLayer, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        MyRenderHelper.drawScreenFrameBuffer((RenderTarget)this.deferredFbs[innerLayer].fb, true, false);
        GL11.glDisable((int)2960);
        this.deferredFbs[outerLayer].fb.m_83970_();
    }

    private boolean tryRenderViewAreaInDeferredBufferAndIncreaseStencil(PortalLike portal, PoseStack matrixStack) {
        int portalLayer = PortalRendering.getPortalLayer();
        this.initStencilForLayer(portalLayer);
        this.deferredFbs[portalLayer].fb.m_83947_(true);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)514, (int)portalLayer, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7682);
        GlStateManager.m_84513_();
        boolean result = PortalRenderInfo.renderAndDecideVisibility(portal, () -> ViewAreaRenderer.renderPortalArea(portal, Vec3.f_82478_, matrixStack.m_85850_().m_85861_(), RenderSystem.m_157192_(), true, true, true));
        GL11.glDisable((int)2960);
        return result;
    }

    @Override
    public void invokeWorldRendering(WorldRenderInfo worldRenderInfo) {
        MyGameRenderer.renderWorldNew(worldRenderInfo, Runnable::run);
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    protected void renderPortals(PoseStack matrixStack) {
        List<PortalLike> portalsToRender = this.getPortalsToRender(matrixStack);
        for (PortalLike portal : portalsToRender) {
            this.doRenderPortal(portal, matrixStack);
        }
    }
}

