/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat.mixin;

import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ShaderBindingContext;
import org.lwjgl.opengl.GL20C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.q_misc_util.Helper;

@Pseudo
@Mixin(targets={"me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderInterface"}, remap=false)
public class MixinSodiumChunkShaderInterface {
    private int uIPClippingEquation = -1;

    private void ip_init(int shaderId) {
        this.uIPClippingEquation = GL20C.glGetUniformLocation((int)shaderId, (CharSequence)"imm_ptl_ClippingEquation");
        if (this.uIPClippingEquation < 0) {
            Helper.err("uniform imm_ptl_ClippingEquation not found in transformed sodium shader");
            this.uIPClippingEquation = -1;
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, require=0, remap=false)
    private void onInit(ShaderBindingContext context, ChunkShaderOptions options, CallbackInfo ci) {
        if (context instanceof GlObject) {
            GlObject glObject = (GlObject)context;
            this.ip_init(glObject.handle());
        } else {
            Helper.log("Skipping sodium shader init injection");
        }
    }

    @Inject(method={"setup"}, at={@At(value="RETURN")}, remap=false)
    private void onSetup(ChunkVertexType vertexType, CallbackInfo ci) {
        if (this.uIPClippingEquation != -1) {
            if (FrontClipping.isClippingEnabled) {
                double[] equation = FrontClipping.getActiveClipPlaneEquationForEntities();
                GL20C.glUniform4f((int)this.uIPClippingEquation, (float)((float)equation[0]), (float)((float)equation[1]), (float)((float)equation[2]), (float)((float)equation[3]));
            } else {
                GL20C.glUniform4f((int)this.uIPClippingEquation, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }
}

