/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPModMain;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.commands.SubCommandArgumentType;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.IPModEntryClient;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.platform_specific.PehkuiInterfaceInitializer;
import qouteall.imm_ptl.core.platform_specific.RequiemCompat;
import qouteall.imm_ptl.core.platform_specific.forge.networking.IPMessage;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGenManagement;
import qouteall.q_misc_util.Helper;

@Mod(value="imm_ptl_core")
public class IPModEntry {
    public static final String MODID = "imm_ptl_core";

    public IPModEntry() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            IPModEntryClient.onInitializeClient();
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(IPConfig.class);
        MinecraftForge.EVENT_BUS.addListener(IPModEntry::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(IPModEntry::onEntityChangeDimension);
        MinecraftForge.EVENT_BUS.addListener(IPModEntry::onPlayerChangeDimension);
        FMLJavaModLoadingContext.get().getModEventBus().register(IPModEntry.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(IPRegistry.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(SubCommandArgumentType.class);
        IPModMain.init();
        RequiemCompat.init();
        IPRegistry.registerEntities(FMLJavaModLoadingContext.get().getModEventBus());
        IPRegistry.registerMyDimensionsFabric();
        IPRegistry.registerChunkGenerators();
        if (ModList.get().isLoaded("dimthread")) {
            O_O.isDimensionalThreadingPresent = true;
            Helper.log("Dimensional Threading is present");
        } else {
            Helper.log("Dimensional Threading is not present");
        }
        if (O_O.getIsPehkuiPresent()) {
            PehkuiInterfaceInitializer.init();
            Helper.log("Pehkui is present");
        } else {
            Helper.log("Pehkui is not present");
        }
        if (ModList.get().isLoaded("gravitychanger")) {
            Helper.log("Gravity API is present");
        } else {
            Helper.log("Gravity API is not present");
        }
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        Helper.log("imm_ptl_core commonSetup called");
        IPMessage.register();
    }

    public static void registerCommands(RegisterCommandsEvent event) {
        Helper.log("imm_ptl_core registerCommands called");
        PortalCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void onEntityChangeDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        CustomPortalGenManagement.onBeforeConventionalDimensionChange(player);
        IPGlobal.chunkDataSyncManager.removePlayerFromChunkTrackersAndEntityTrackers(player);
    }

    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CustomPortalGenManagement.onAfterConventionalDimensionChange((ServerPlayer)event.getEntity());
    }
}

