/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific.forge.networking;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;

public class Teleport {
    private ResourceKey<Level> dimensionBefore;
    private Vec3 posBefore;
    private UUID portalEntityId;

    public Teleport(ResourceKey<Level> dimensionBefore, Vec3 posBefore, UUID portalEntityId) {
        this.dimensionBefore = dimensionBefore;
        this.posBefore = posBefore;
        this.portalEntityId = portalEntityId;
    }

    public Teleport(FriendlyByteBuf buf) {
        this.dimensionBefore = DimId.readWorldId(buf, false);
        this.posBefore = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.portalEntityId = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        DimId.writeWorldId(buf, this.dimensionBefore, true);
        buf.writeDouble(this.posBefore.f_82479_);
        buf.writeDouble(this.posBefore.f_82480_);
        buf.writeDouble(this.posBefore.f_82481_);
        buf.m_130077_(this.portalEntityId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> MiscHelper.executeOnServerThread(() -> IPGlobal.serverTeleportationManager.onPlayerTeleportedInClient(ctx.getSender(), this.dimensionBefore, this.posBefore, this.portalEntityId)));
        ctx.setPacketHandled(true);
        return true;
    }
}

