/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;

public class PortalExtension {
    public double motionAffinity = 0.0;
    public boolean adjustPositionAfterTeleport = true;
    public boolean bindCluster = true;
    @Nullable
    public UUID reversePortalId;
    @Nullable
    public UUID flippedPortalId;
    @Nullable
    public UUID parallelPortalId;
    @Nullable
    public Portal reversePortal;
    @Nullable
    public Portal flippedPortal;
    @Nullable
    public Portal parallelPortal;

    public static PortalExtension get(Portal portal) {
        if (portal.extension == null) {
            portal.extension = new PortalExtension();
        }
        return portal.extension;
    }

    public static void init() {
        Portal.clientPortalTickSignal.connect(portal -> PortalExtension.get(portal).tick((Portal)portal));
        Portal.serverPortalTickSignal.connect(portal -> PortalExtension.get(portal).tick((Portal)portal));
        Portal.readPortalDataSignal.connect((portal, tag) -> PortalExtension.get(portal).readFromNbt((CompoundTag)tag));
        Portal.writePortalDataSignal.connect((portal, tag) -> PortalExtension.get(portal).writeToNbt((CompoundTag)tag));
    }

    private void readFromNbt(CompoundTag compoundTag) {
        this.motionAffinity = compoundTag.m_128441_("motionAffinity") ? compoundTag.m_128459_("motionAffinity") : 0.0;
        this.adjustPositionAfterTeleport = compoundTag.m_128441_("adjustPositionAfterTeleport") ? compoundTag.m_128471_("adjustPositionAfterTeleport") : true;
        this.bindCluster = compoundTag.m_128441_("bindCluster") ? compoundTag.m_128471_("bindCluster") : true;
        this.reversePortalId = compoundTag.m_128441_("reversePortalId") ? compoundTag.m_128342_("reversePortalId") : null;
        this.flippedPortalId = compoundTag.m_128441_("flippedPortalId") ? compoundTag.m_128342_("flippedPortalId") : null;
        this.parallelPortalId = compoundTag.m_128441_("parallelPortalId") ? compoundTag.m_128342_("parallelPortalId") : null;
    }

    private void writeToNbt(CompoundTag compoundTag) {
        if (this.motionAffinity != 0.0) {
            compoundTag.m_128347_("motionAffinity", this.motionAffinity);
        }
        compoundTag.m_128379_("adjustPositionAfterTeleport", this.adjustPositionAfterTeleport);
        compoundTag.m_128379_("bindCluster", this.bindCluster);
        if (this.reversePortalId != null) {
            compoundTag.m_128362_("reversePortalId", this.reversePortalId);
        }
        if (this.flippedPortalId != null) {
            compoundTag.m_128362_("flippedPortalId", this.flippedPortalId);
        }
        if (this.parallelPortalId != null) {
            compoundTag.m_128362_("parallelPortalId", this.parallelPortalId);
        }
    }

    private void tick(Portal portal) {
        if (portal.f_19853_.m_5776_()) {
            this.updateClusterStatusClient(portal);
        } else {
            this.updateClusterStatusServer(portal);
        }
    }

    private void updateClusterStatusServer(Portal portal) {
        boolean needsUpdate = false;
        if (this.bindCluster) {
            Portal p;
            Entity e;
            if (this.flippedPortal != null && this.flippedPortal.m_213877_()) {
                this.flippedPortal = null;
            }
            if (this.reversePortal != null && this.reversePortal.m_213877_()) {
                this.reversePortal = null;
            }
            if (this.parallelPortal != null && this.parallelPortal.m_213877_()) {
                this.parallelPortal = null;
            }
            if (this.flippedPortalId != null && this.flippedPortal == null) {
                e = (Entity)((IEWorld)portal.f_19853_).portal_getEntityLookup().m_142694_(this.flippedPortalId);
                if (e instanceof Portal) {
                    this.flippedPortal = p = (Portal)e;
                } else {
                    this.flippedPortalId = null;
                    needsUpdate = true;
                }
            }
            if (this.flippedPortalId == null) {
                this.flippedPortal = PortalManipulation.findFlippedPortal(portal);
                if (this.flippedPortal != null) {
                    this.flippedPortalId = this.flippedPortal.m_20148_();
                    needsUpdate = true;
                }
            }
            if (this.reversePortalId != null && this.reversePortal == null) {
                e = (Entity)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().m_142694_(this.reversePortalId);
                if (e instanceof Portal) {
                    this.reversePortal = p = (Portal)e;
                } else if (portal.isOtherSideChunkLoaded()) {
                    this.reversePortalId = null;
                    needsUpdate = true;
                }
            }
            if (this.reversePortalId == null) {
                this.reversePortal = PortalManipulation.findReversePortal(portal);
                if (this.reversePortal != null) {
                    this.reversePortalId = this.reversePortal.m_20148_();
                    needsUpdate = true;
                }
            }
            if (this.parallelPortalId != null && this.parallelPortal == null) {
                e = (Entity)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().m_142694_(this.parallelPortalId);
                if (e instanceof Portal) {
                    this.parallelPortal = p = (Portal)e;
                } else if (portal.isOtherSideChunkLoaded()) {
                    this.parallelPortalId = null;
                    needsUpdate = true;
                }
            }
            if (this.parallelPortalId == null) {
                this.parallelPortal = PortalManipulation.findParallelPortal(portal);
                if (this.parallelPortal != null) {
                    this.parallelPortalId = this.parallelPortal.m_20148_();
                    needsUpdate = true;
                }
            }
        } else {
            this.flippedPortal = null;
            this.reversePortal = null;
            this.parallelPortal = null;
            this.flippedPortalId = null;
            this.reversePortalId = null;
            this.parallelPortalId = null;
        }
        if (this.flippedPortal != null) {
            PortalExtension.get((Portal)this.flippedPortal).bindCluster = true;
        }
        if (this.reversePortal != null) {
            PortalExtension.get((Portal)this.reversePortal).bindCluster = true;
        }
        if (this.parallelPortal != null) {
            PortalExtension.get((Portal)this.parallelPortal).bindCluster = true;
        }
        if (needsUpdate) {
            portal.reloadAndSyncToClient();
        }
    }

    private void updateClusterStatusClient(Portal portal) {
        if (this.bindCluster) {
            Portal p;
            Entity e;
            if (this.flippedPortalId != null) {
                e = (Entity)((IEWorld)portal.f_19853_).portal_getEntityLookup().m_142694_(this.flippedPortalId);
                if (e instanceof Portal) {
                    this.flippedPortal = p = (Portal)e;
                }
            } else {
                this.flippedPortal = null;
            }
            if (this.reversePortalId != null) {
                e = (Entity)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().m_142694_(this.reversePortalId);
                if (e instanceof Portal) {
                    this.reversePortal = p = (Portal)e;
                }
            } else {
                this.reversePortal = null;
            }
            if (this.parallelPortalId != null) {
                e = (Entity)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().m_142694_(this.parallelPortalId);
                if (e instanceof Portal) {
                    this.parallelPortal = p = (Portal)e;
                }
            } else {
                this.parallelPortal = null;
            }
        } else {
            this.flippedPortal = null;
            this.reversePortal = null;
            this.parallelPortal = null;
        }
    }

    public void rectifyClusterPortals(Portal portal, boolean sync) {
        portal.animation.defaultAnimation.inverseScale = false;
        if (this.flippedPortal != null) {
            this.flippedPortal = ServerTeleportationManager.teleportRegularEntityTo(this.flippedPortal, (ResourceKey<Level>)portal.f_19853_.m_46472_(), portal.getOriginPos());
            this.flippedPortal.dimensionTo = portal.dimensionTo;
            this.flippedPortal.setOriginPos(portal.getOriginPos());
            this.flippedPortal.setDestination(portal.getDestPos());
            this.flippedPortal.axisW = portal.axisW;
            this.flippedPortal.axisH = portal.axisH.m_82490_(-1.0);
            this.flippedPortal.scaling = portal.scaling;
            this.flippedPortal.rotation = portal.rotation;
            if (this.flippedPortal.specialShape == null) {
                this.flippedPortal.width = portal.width;
                this.flippedPortal.height = portal.height;
            }
            PortalManipulation.copyAdditionalProperties(this.flippedPortal, portal, false);
            this.flippedPortal.animation.defaultAnimation.inverseScale = false;
            if (sync) {
                this.flippedPortal.reloadAndSyncToClient();
            }
        }
        if (this.reversePortal != null) {
            this.reversePortal = ServerTeleportationManager.teleportRegularEntityTo(this.reversePortal, portal.getDestDim(), portal.getDestPos());
            this.reversePortalId = this.reversePortal.m_20148_();
            this.reversePortal.dimensionTo = portal.getOriginDim();
            this.reversePortal.setOriginPos(portal.getDestPos());
            this.reversePortal.setDestination(portal.getOriginPos());
            this.reversePortal.axisW = portal.transformLocalVecNonScale(portal.axisW);
            this.reversePortal.axisH = portal.transformLocalVecNonScale(portal.axisH.m_82490_(-1.0));
            this.reversePortal.scaling = 1.0 / portal.scaling;
            if (portal.rotation != null) {
                this.reversePortal.rotation = portal.rotation.m_80161_();
                this.reversePortal.rotation.m_80157_();
            } else {
                this.reversePortal.rotation = null;
            }
            if (this.reversePortal.specialShape == null) {
                this.reversePortal.width = portal.width * portal.getScale();
                this.reversePortal.height = portal.height * portal.getScale();
            }
            PortalManipulation.copyAdditionalProperties(this.reversePortal, portal, false);
            this.reversePortal.animation.defaultAnimation.inverseScale = true;
            if (sync) {
                this.reversePortal.reloadAndSyncToClient();
            }
        }
        if (this.parallelPortal != null) {
            this.parallelPortal = ServerTeleportationManager.teleportRegularEntityTo(this.parallelPortal, portal.getDestDim(), portal.getDestPos());
            this.parallelPortalId = this.parallelPortal.m_20148_();
            this.parallelPortal.dimensionTo = portal.getOriginDim();
            this.parallelPortal.setOriginPos(portal.getDestPos());
            this.parallelPortal.setDestination(portal.getOriginPos());
            this.parallelPortal.axisW = portal.transformLocalVecNonScale(portal.axisW);
            this.parallelPortal.axisH = portal.transformLocalVecNonScale(portal.axisH);
            this.parallelPortal.scaling = 1.0 / portal.scaling;
            if (portal.rotation != null) {
                this.parallelPortal.rotation = portal.rotation.m_80161_();
                this.parallelPortal.rotation.m_80157_();
            } else {
                this.parallelPortal.rotation = null;
            }
            if (this.parallelPortal.specialShape == null) {
                this.parallelPortal.width = portal.width * portal.getScale();
                this.parallelPortal.height = portal.height * portal.getScale();
            }
            PortalManipulation.copyAdditionalProperties(this.parallelPortal, portal, false);
            this.parallelPortal.animation.defaultAnimation.inverseScale = true;
            if (sync) {
                this.parallelPortal.reloadAndSyncToClient();
            }
        }
    }

    public static void initializeClusterBind(Portal f1, Portal f2, Portal t1, Portal t2) {
        PortalExtension.get((Portal)f1).bindCluster = true;
        PortalExtension.get((Portal)f2).bindCluster = true;
        PortalExtension.get((Portal)t1).bindCluster = true;
        PortalExtension.get((Portal)t2).bindCluster = true;
        PortalExtension.get((Portal)f1).flippedPortalId = f2.m_20148_();
        PortalExtension.get((Portal)f2).flippedPortalId = f1.m_20148_();
        PortalExtension.get((Portal)t1).flippedPortalId = t2.m_20148_();
        PortalExtension.get((Portal)t2).flippedPortalId = t1.m_20148_();
        PortalExtension.get((Portal)f1).reversePortalId = t1.m_20148_();
        PortalExtension.get((Portal)t1).reversePortalId = f1.m_20148_();
        PortalExtension.get((Portal)f2).reversePortalId = t2.m_20148_();
        PortalExtension.get((Portal)t2).reversePortalId = f2.m_20148_();
        PortalExtension.get((Portal)f1).parallelPortalId = t2.m_20148_();
        PortalExtension.get((Portal)t2).parallelPortalId = f1.m_20148_();
        PortalExtension.get((Portal)f2).parallelPortalId = t1.m_20148_();
        PortalExtension.get((Portal)t1).parallelPortalId = f2.m_20148_();
    }

    public static void forClusterPortals(Portal portal, Consumer<Portal> func) {
        func.accept(portal);
        PortalExtension.forConnectedPortals(portal, func);
    }

    public static void forConnectedPortals(Portal portal, Consumer<Portal> func) {
        PortalExtension extension = PortalExtension.get(portal);
        if (extension.flippedPortal != null) {
            func.accept(extension.flippedPortal);
        }
        if (extension.reversePortal != null) {
            func.accept(extension.reversePortal);
        }
        if (extension.parallelPortal != null) {
            func.accept(extension.parallelPortal);
        }
    }

    public static void forEachClusterPortal(Portal portal, Consumer<Portal> forThis, Consumer<Portal> forFlipped, Consumer<Portal> forReverse, Consumer<Portal> forParallel) {
        forThis.accept(portal);
        PortalExtension extension = PortalExtension.get(portal);
        if (extension.flippedPortal != null) {
            forFlipped.accept(extension.flippedPortal);
        }
        if (extension.reversePortal != null) {
            forReverse.accept(extension.reversePortal);
        }
        if (extension.parallelPortal != null) {
            forParallel.accept(extension.parallelPortal);
        }
    }
}

