/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.BoxPredicate;
import qouteall.q_misc_util.my_util.Plane;

public interface PortalLike {
    @OnlyIn(value=Dist.CLIENT)
    public BoxPredicate getInnerFrustumCullingFunc(double var1, double var3, double var5);

    public boolean isConventionalPortal();

    public AABB getExactAreaBox();

    public Vec3 transformPoint(Vec3 var1);

    public Vec3 transformLocalVec(Vec3 var1);

    public Vec3 inverseTransformLocalVec(Vec3 var1);

    public Vec3 inverseTransformPoint(Vec3 var1);

    public double getDistanceToNearestPointInPortal(Vec3 var1);

    public double getDestAreaRadiusEstimation();

    public Vec3 getOriginPos();

    public Vec3 getDestPos();

    public Level getOriginWorld();

    public Level getDestWorld();

    public ResourceKey<Level> getDestDim();

    public boolean isRoughlyVisibleTo(Vec3 var1);

    @Nullable
    public Plane getInnerClipping();

    @Nullable
    public Quaternion getRotation();

    public double getScale();

    public boolean getIsGlobal();

    public boolean isVisible();

    @Nullable
    public Vec3[] getOuterFrustumCullingVertices();

    @OnlyIn(value=Dist.CLIENT)
    public void renderViewAreaMesh(Vec3 var1, Consumer<Vec3> var2);

    @Nullable
    public Matrix4f getAdditionalCameraTransformation();

    @Nullable
    public UUID getDiscriminator();

    public boolean cannotRenderInMe(Portal var1);

    public boolean isFuseView();

    public boolean getDoRenderPlayer();

    public boolean getHasCrossPortalCollision();

    default public boolean hasScaling() {
        return Math.abs(this.getScale() - 1.0) > 0.01;
    }

    default public ResourceKey<Level> getOriginDim() {
        return this.getOriginWorld().m_46472_();
    }

    default public boolean isInside(Vec3 entityPos, double valve) {
        Plane innerClipping = this.getInnerClipping();
        if (innerClipping == null) {
            return true;
        }
        double v = entityPos.m_82546_(innerClipping.pos).m_82526_(innerClipping.normal);
        return v > valve;
    }

    default public double getSizeEstimation() {
        Vec3 boxSize = Helper.getBoxSize(this.getExactAreaBox());
        double maxDimension = Math.max(Math.max(boxSize.f_82479_, boxSize.f_82480_), boxSize.f_82481_);
        return maxDimension;
    }
}

