/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.DefaultPortalAnimation;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.q_misc_util.Helper;

@OnlyIn(value=Dist.CLIENT)
public class ClientPortalAnimationManagement {
    private static final Map<Portal, RunningDefaultAnimation> defaultAnimatedPortals = new HashMap<Portal, RunningDefaultAnimation>();
    private static final HashSet<Portal> customAnimatedPortals = new HashSet();

    public static void init() {
        IPGlobal.clientCleanupSignal.connect(ClientPortalAnimationManagement::cleanup);
        ClientWorldLoader.clientDimensionDynamicRemoveSignal.connect(dim -> ClientPortalAnimationManagement.cleanup());
    }

    public static void addDefaultAnimation(Portal portal, PortalState fromState, PortalState toState, DefaultPortalAnimation animation) {
        if (animation.durationTicks <= 0) {
            return;
        }
        long currTime = System.nanoTime();
        RunningDefaultAnimation runningDefaultAnimation = new RunningDefaultAnimation(fromState, toState, currTime, currTime + Helper.secondToNano((double)animation.durationTicks / 20.0), animation.timingFunction, animation.inverseScale);
        defaultAnimatedPortals.put(portal, runningDefaultAnimation);
    }

    public static void markRequiresCustomAnimationUpdate(Portal portal) {
        customAnimatedPortals.add(portal);
        defaultAnimatedPortals.remove(portal);
    }

    public static void onAfterClientTick() {
        ClientPortalAnimationManagement.updateCustomAnimations(true);
        ClientPortalAnimationManagement.updateCustomAnimations(false);
    }

    public static void update() {
        long currTime = System.nanoTime();
        defaultAnimatedPortals.entrySet().removeIf(entry -> {
            Portal portal = (Portal)entry.getKey();
            RunningDefaultAnimation animation = (RunningDefaultAnimation)entry.getValue();
            if (portal.m_213877_()) {
                return true;
            }
            if (currTime > animation.toTimeNano) {
                portal.setPortalState(animation.toState);
                return true;
            }
            PortalState currentState = animation.getCurrentState(currTime);
            if (currentState.fromWorld != portal.getOriginDim()) {
                return true;
            }
            if (currentState.toWorld != portal.getDestDim()) {
                return true;
            }
            portal.setPortalState(currentState);
            return false;
        });
        ClientPortalAnimationManagement.updateCustomAnimations(false);
    }

    private static void updateCustomAnimations(boolean isTicking) {
        long stableTickTime = StableClientTimer.getStableTickTime();
        float stablePartialTicks = StableClientTimer.getStablePartialTicks();
        long usedTickTime = isTicking ? stableTickTime + 1L : stableTickTime;
        float usedPartialTicks = stablePartialTicks;
        customAnimatedPortals.removeIf(portal -> {
            if (portal.m_213877_()) {
                return true;
            }
            if (!portal.animation.hasRunningAnimationDriver()) {
                return true;
            }
            if (portal.animation.isPaused()) {
                return false;
            }
            portal.animation.updateAnimationDriver((Portal)portal, portal.animation, usedTickTime, usedPartialTicks, isTicking, !isTicking);
            return !portal.animation.hasRunningAnimationDriver();
        });
    }

    private static void cleanup() {
        defaultAnimatedPortals.clear();
        customAnimatedPortals.clear();
    }

    public static void foreachCustomAnimatedPortals(Consumer<Portal> consumer) {
        customAnimatedPortals.forEach(consumer);
    }

    public static class RunningDefaultAnimation {
        public PortalState fromState;
        public PortalState toState;
        public long startTimeNano;
        public long toTimeNano;
        public TimingFunction timingFunction;
        public boolean inverseScale;

        public RunningDefaultAnimation(PortalState fromState, PortalState toState, long startTimeNano, long toTimeNano, TimingFunction timingFunction, boolean inverseScale) {
            this.fromState = fromState;
            this.toState = toState;
            this.startTimeNano = startTimeNano;
            this.toTimeNano = toTimeNano;
            this.timingFunction = timingFunction;
            this.inverseScale = inverseScale;
        }

        public PortalState getCurrentState(long currTime) {
            double progress = (double)(currTime - this.startTimeNano) / (double)(this.toTimeNano - this.startTimeNano);
            if (progress < 0.0) {
                Helper.err("invalid portal animation");
                progress = 0.0;
            }
            progress = this.timingFunction.mapProgress(progress);
            PortalState currState = PortalState.interpolate(this.fromState, this.toState, progress, this.inverseScale);
            return currState;
        }
    }
}

