/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Stack;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.ducks.IEBuiltChunk;
import qouteall.imm_ptl.core.miscellaneous.ClientPerformanceMonitor;
import qouteall.imm_ptl.core.portal.nether_portal.BlockTraverse;
import qouteall.imm_ptl.core.render.MyBuiltChunkStorage;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;

@OnlyIn(value=Dist.CLIENT)
public class VisibleSectionDiscovery {
    private static MyBuiltChunkStorage builtChunks;
    private static Frustum vanillaFrustum;
    private static ObjectArrayList<LevelRenderer.RenderChunkInfo> resultHolder;
    private static final ArrayDeque<ChunkRenderDispatcher.RenderChunk> tempQueue;
    private static SectionPos cameraSectionPos;
    private static long timeMark;
    private static int viewDistance;
    private static final Stack<ObjectArrayList<LevelRenderer.RenderChunkInfo>> listCaches;

    public static void discoverVisibleSections(ClientLevel world, MyBuiltChunkStorage builtChunks_, Camera camera, Frustum vanillaFrustum_, ObjectArrayList<LevelRenderer.RenderChunkInfo> resultHolder_) {
        builtChunks = builtChunks_;
        vanillaFrustum = vanillaFrustum_;
        resultHolder = resultHolder_;
        resultHolder.clear();
        tempQueue.clear();
        VisibleSectionDiscovery.updateViewDistance();
        timeMark = System.nanoTime();
        Vec3 cameraPos = camera.m_90583_();
        vanillaFrustum.m_113002_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
        cameraSectionPos = SectionPos.m_123199_((BlockPos)new BlockPos(cameraPos));
        if (cameraPos.f_82480_ < (double)world.m_141937_()) {
            VisibleSectionDiscovery.discoverBottomOrTopLayerVisibleChunks(VisibleSectionDiscovery.builtChunks.minSectionY);
        } else if (cameraPos.f_82480_ > (double)world.m_151558_()) {
            VisibleSectionDiscovery.discoverBottomOrTopLayerVisibleChunks(VisibleSectionDiscovery.builtChunks.endSectionY - 1);
        } else {
            VisibleSectionDiscovery.checkSection(cameraSectionPos.m_123170_(), cameraSectionPos.m_123206_(), cameraSectionPos.m_123222_(), true);
        }
        while (!tempQueue.isEmpty()) {
            ChunkRenderDispatcher.RenderChunk curr = tempQueue.poll();
            int cx = SectionPos.m_123171_((int)curr.m_112839_().m_123341_());
            int cy = SectionPos.m_123171_((int)curr.m_112839_().m_123342_());
            int cz = SectionPos.m_123171_((int)curr.m_112839_().m_123343_());
            VisibleSectionDiscovery.checkSection(cx + 1, cy, cz, false);
            VisibleSectionDiscovery.checkSection(cx - 1, cy, cz, false);
            VisibleSectionDiscovery.checkSection(cx, cy + 1, cz, false);
            VisibleSectionDiscovery.checkSection(cx, cy - 1, cz, false);
            VisibleSectionDiscovery.checkSection(cx, cy, cz + 1, false);
            VisibleSectionDiscovery.checkSection(cx, cy, cz - 1, false);
        }
        resultHolder = null;
        builtChunks = null;
        vanillaFrustum = null;
    }

    private static void updateViewDistance() {
        int distance = WorldRenderInfo.getRenderDistance();
        viewDistance = PerformanceLevel.getPortalRenderingDistance(ClientPerformanceMonitor.level, distance);
    }

    private static boolean isVisible(ChunkRenderDispatcher.RenderChunk builtChunk) {
        AABB box = builtChunk.m_202440_();
        return vanillaFrustum.m_113029_(box);
    }

    private static void discoverBottomOrTopLayerVisibleChunks(int cy) {
        BlockTraverse.searchOnPlane(cameraSectionPos.m_123170_(), cameraSectionPos.m_123222_(), viewDistance - 1, (cx, cz) -> {
            VisibleSectionDiscovery.checkSection(cx, cy, cz, false);
            return null;
        });
    }

    private static void checkSection(int cx, int cy, int cz, boolean skipFrustumTest) {
        IEBuiltChunk ieBuiltChunk;
        if (Math.abs(cx - cameraSectionPos.m_123170_()) > viewDistance) {
            return;
        }
        if (Math.abs(cy - cameraSectionPos.m_123206_()) > viewDistance) {
            return;
        }
        if (Math.abs(cz - cameraSectionPos.m_123222_()) > viewDistance) {
            return;
        }
        ChunkRenderDispatcher.RenderChunk builtChunk = builtChunks.rawFetch(cx, cy, cz, timeMark);
        if (builtChunk != null && (ieBuiltChunk = (IEBuiltChunk)builtChunk).portal_getMark() != timeMark) {
            ieBuiltChunk.portal_setMark(timeMark);
            if (skipFrustumTest || VisibleSectionDiscovery.isVisible(builtChunk)) {
                tempQueue.add(builtChunk);
                resultHolder.add((Object)ieBuiltChunk.portal_getDummyChunkInfo());
            }
        }
    }

    public static ObjectArrayList<LevelRenderer.RenderChunkInfo> takeList() {
        if (listCaches.isEmpty()) {
            return new ObjectArrayList();
        }
        return listCaches.pop();
    }

    public static void returnList(ObjectArrayList<LevelRenderer.RenderChunkInfo> list) {
        list.clear();
        listCaches.push(list);
    }

    public static void init() {
        IPGlobal.clientCleanupSignal.connect(VisibleSectionDiscovery::cleanUp);
        ClientWorldLoader.clientDimensionDynamicRemoveSignal.connect(dim -> VisibleSectionDiscovery.cleanUp());
    }

    private static void cleanUp() {
        listCaches.clear();
        resultHolder = null;
        builtChunks = null;
        vanillaFrustum = null;
    }

    static {
        tempQueue = new ArrayDeque();
        listCaches = new Stack();
    }
}

