/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import qouteall.imm_ptl.peripheral.alternate_dimension.RandomSelector;
import qouteall.imm_ptl.peripheral.alternate_dimension.RegionErrorTerrainGenerator;

public class ErrorTerrainComposition {
    public static final BlockState air = Blocks.f_50016_.m_49966_();
    public static final BlockState stone = Blocks.f_50069_.m_49966_();
    public static final BlockState water = Blocks.f_49990_.m_49966_();
    public static final RegionErrorTerrainGenerator.Composition mountain = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        if (funcValue > middle) {
            if (funcValue > middle * middle) {
                return air;
            }
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition classicalSolid = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 32.0);
        if (funcValue > splitPoint) {
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition classicalHollow = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 32.0);
        if (funcValue > splitPoint) {
            if (funcValue > splitPoint + 2.0) {
                return air;
            }
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition classicalWatery = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 16.0);
        if (funcValue > splitPoint) {
            if ((int)funcValue % 23 == 0) {
                return water;
            }
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition newSolid = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint1 = Math.abs(middle);
        splitPoint1 *= Math.exp((double)Math.abs(worldY - 64) / 32.0 - 1.0);
        double splitPoint = splitPoint1 *= Math.max(1.0, 100.0 / (double)Math.max(1, Math.min(worldY, 128 - worldY)));
        if (funcValue > splitPoint) {
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition floatingSea = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 16.0);
        if (funcValue > splitPoint) {
            if (worldY > 63) {
                return water;
            }
            return stone;
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition treasured = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        if (worldY > 32) {
            return air;
        }
        double upPoint = Math.max(middle, Math.max(upMiddle, downMiddle));
        double splitPoint = Mth.m_14139_((double)((double)Math.abs(worldY - 32) / 32.0), (double)middle, (double)(worldY > 32 ? upMiddle : downMiddle));
        if (funcValue > splitPoint && (int)funcValue % 37 == 0) {
            Block randomBlock = (Block)((Holder)Registry.f_122824_.m_213642_(RandomSource.m_216327_()).get()).m_203334_();
            if (randomBlock == Blocks.f_50273_) {
                randomBlock = Blocks.f_50016_;
            }
            return randomBlock.m_49966_();
        }
        return air;
    };
    public static final RegionErrorTerrainGenerator.Composition layeredHollow = (worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ) -> {
        double splitPoint = ErrorTerrainComposition.getSplitPointClassical(worldY, middle, 32.0);
        if (funcValue > splitPoint) {
            double v = (funcValue - splitPoint) / 4.0;
            if (v > Math.floor(v) + 0.5) {
                return air;
            }
            return stone;
        }
        return air;
    };
    public static final RandomSelector<RegionErrorTerrainGenerator.Composition> selector = new RandomSelector.Builder<RegionErrorTerrainGenerator.Composition>().add(25, mountain).add(40, classicalSolid).add(50, classicalHollow).add(10, classicalWatery).add(10, newSolid).add(30, floatingSea).add(1, treasured).add(15, layeredHollow).build();

    private static double getSplitPointClassical(int worldY, double middle, double unitFactor) {
        double splitPoint = middle;
        splitPoint *= Math.exp((double)Math.abs(worldY - 64) / unitFactor);
        return splitPoint *= Math.max(0.7, 30.0 / (double)Math.max(1, Math.min(worldY, 128 - worldY)));
    }
}

