/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.guide;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPNetworkingClient;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;
import qouteall.q_misc_util.my_util.MyTaskList;

@OnlyIn(value=Dist.CLIENT)
public class IPOuterClientMisc {
    private static OuterConfig outerConfig = new OuterConfig();

    private static OuterConfig readFromFile() {
        File storageFile = IPOuterClientMisc.getStorageFile();
        if (storageFile.exists()) {
            OuterConfig result = null;
            try (FileReader fileReader = new FileReader(storageFile);){
                result = (OuterConfig)IPGlobal.gson.fromJson((Reader)fileReader, OuterConfig.class);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new OuterConfig();
            }
            if (result == null) {
                return new OuterConfig();
            }
            return result;
        }
        return new OuterConfig();
    }

    private static File getStorageFile() {
        return new File(Minecraft.m_91087_().f_91069_, "imm_ptl_state.json");
    }

    private static void writeToFile(OuterConfig outerConfig) {
        try (FileWriter fileWriter = new FileWriter(IPOuterClientMisc.getStorageFile());){
            IPGlobal.gson.toJson((Object)outerConfig, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initClient() {
        outerConfig = IPOuterClientMisc.readFromFile();
        IPNetworkingClient.clientPortalSpawnSignal.connect(p -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (!IPOuterClientMisc.outerConfig.wikiInformed && player != null && player.m_7500_()) {
                IPOuterClientMisc.outerConfig.wikiInformed = true;
                IPOuterClientMisc.writeToFile(outerConfig);
                IPOuterClientMisc.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization", Component.m_237115_((String)"imm_ptl.inform_wiki"));
            }
            if (!IPOuterClientMisc.outerConfig.lagInformed && player != null) {
                IPOuterClientMisc.outerConfig.lagInformed = true;
                IPOuterClientMisc.writeToFile(outerConfig);
                IPGlobal.clientTaskList.addTask(MyTaskList.withDelay(100, () -> {
                    CHelper.printChat((Component)Component.m_237115_((String)"imm_ptl.about_lag"));
                    return true;
                }));
            }
        });
    }

    public static void onClientPlacePortalHelper() {
        if (!IPOuterClientMisc.outerConfig.portalHelperInformed) {
            IPOuterClientMisc.outerConfig.portalHelperInformed = true;
            IPOuterClientMisc.writeToFile(outerConfig);
            IPOuterClientMisc.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization#portal-helper-block", Component.m_237115_((String)"imm_ptl.inform_portal_helper"));
        }
    }

    private static void informWithURL(String link, MutableComponent text) {
        CHelper.printChat((Component)text.m_7220_((Component)McHelper.getLinkText(link)));
    }

    @Nullable
    public static DimStackInfo getDimStackPreset() {
        return IPOuterClientMisc.outerConfig.dimensionStackDefault;
    }

    public static void setDimStackPreset(@Nullable DimStackInfo info) {
        IPOuterClientMisc.outerConfig.dimensionStackDefault = info;
        IPOuterClientMisc.writeToFile(outerConfig);
    }

    public static class OuterConfig {
        public boolean wikiInformed = false;
        public boolean portalHelperInformed = false;
        public boolean lagInformed = false;
        @Nullable
        public DimStackInfo dimensionStackDefault = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RemoteCallables {
        public static void showWiki() {
            IPOuterClientMisc.informWithURL("https://qouteall.fun/immptl/wiki/Commands-Reference", Component.m_237113_((String)""));
        }
    }
}

