/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.mixin.client.dim_stack;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldGenSettingsComponent;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackScreen;
import qouteall.imm_ptl.peripheral.ducks.IECreateWorldScreen;
import qouteall.imm_ptl.peripheral.guide.IPOuterClientMisc;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.forge.events.ServerDimensionsLoadEvent;

@Mixin(value={CreateWorldScreen.class})
public abstract class MixinCreateWorldScreen
extends Screen
implements IECreateWorldScreen {
    @Shadow
    protected DataPackConfig f_100846_;
    @Shadow
    @Final
    public WorldGenSettingsComponent f_100847_;
    private Button dimStackButton;
    @javax.annotation.Nullable
    private DimStackScreen ip_dimStackScreen;
    @javax.annotation.Nullable
    private WorldGenSettings ip_lastWorldGenSettings;
    @javax.annotation.Nullable
    private RegistryAccess ip_lastRegistryAccess;

    @Shadow
    public abstract void m_7861_();

    @Shadow
    @Nullable
    protected abstract Pair<File, PackRepository> m_100871_();

    @Shadow
    protected abstract void m_100878_(PackRepository var1);

    protected MixinCreateWorldScreen(Component title) {
        super(title);
        throw new RuntimeException();
    }

    @Inject(method={"<init>(Lnet/minecraft/client/gui/screens/Screen;Lnet/minecraft/world/level/DataPackConfig;Lnet/minecraft/client/gui/screens/worldselection/WorldGenSettingsComponent;)V"}, at={@At(value="RETURN")})
    private void onConstructEnded(Screen screen, DataPackConfig dataPackSettings, WorldGenSettingsComponent moreOptionsDialog, CallbackInfo ci) {
    }

    @Inject(method={"Lnet/minecraft/client/gui/screens/worldselection/CreateWorldScreen;init()V"}, at={@At(value="HEAD")})
    private void onInitEnded(CallbackInfo ci) {
        this.dimStackButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, 151, 150, 20, (Component)Component.m_237115_((String)"imm_ptl.altius_screen_button"), buttonWidget -> this.openDimStackScreen()));
        this.dimStackButton.f_93624_ = false;
    }

    @Inject(method={"Lnet/minecraft/client/gui/screens/worldselection/CreateWorldScreen;setWorldGenSettingsVisible(Z)V"}, at={@At(value="RETURN")})
    private void onMoreOptionsOpen(boolean moreOptionsOpen, CallbackInfo ci) {
        this.dimStackButton.f_93624_ = moreOptionsOpen;
    }

    @Inject(method={"createNewWorld"}, at={@At(value="HEAD")})
    private void onCreateNewWorld(CallbackInfo ci) {
        DimStackInfo info = this.ip_getEffectiveDimStackInfoForWorldCreation();
        if (info != null) {
            DimStackManagement.dimStackToApply = info;
            Helper.log("Generating dimension stack world");
        }
    }

    @javax.annotation.Nullable
    private DimStackInfo ip_getEffectiveDimStackInfoForWorldCreation() {
        if (this.ip_dimStackScreen != null) {
            return this.ip_dimStackScreen.getDimStackInfo();
        }
        return IPOuterClientMisc.getDimStackPreset();
    }

    @Inject(method={"lambda$tryApplyNewDataPacks$18", "m_232885_"}, at={@At(value="RETURN")})
    private void onTryingApplyNewDatapackLoading(ResourceManager resourceManager, DataPackConfig dataPackConfig, CallbackInfoReturnable<Pair<Pair<WorldGenSettings, Lifecycle>, RegistryAccess.Frozen>> cir) {
        this.ip_lastWorldGenSettings = (WorldGenSettings)((Pair)((Pair)cir.getReturnValue()).getFirst()).getFirst();
        this.ip_lastRegistryAccess = (RegistryAccess)((Pair)cir.getReturnValue()).getSecond();
    }

    private void openDimStackScreen() {
        if (this.ip_dimStackScreen == null) {
            this.ip_dimStackScreen = new DimStackScreen((Screen)((CreateWorldScreen)this), this::portal_getDimensionList, a -> {});
        }
        Minecraft.m_91087_().m_91152_((Screen)this.ip_dimStackScreen);
    }

    private List<ResourceKey<Level>> portal_getDimensionList(Screen addDimensionScreen) {
        Helper.log("Getting the dimension list");
        if (this.ip_lastWorldGenSettings == null) {
            Helper.log("Start reloading datapacks for getting the dimension list");
            this.f_100846_ = new DataPackConfig(new ArrayList(), new ArrayList());
            this.m_100878_(this.f_96541_.m_91099_());
            IPGlobal.preTotalRenderTaskList.addTask(() -> {
                if (this.f_96541_.f_91080_ == this) {
                    this.f_96541_.m_91152_(addDimensionScreen);
                    return true;
                }
                return false;
            });
        }
        WorldGenSettings rawGeneratorOptions = this.f_100847_.m_233066_(false).f_232987_();
        WorldGenSettings copiedGeneratorOptions = new WorldGenSettings(rawGeneratorOptions.m_64619_(), rawGeneratorOptions.m_224677_(), rawGeneratorOptions.m_64660_(), MiscHelper.filterAndCopyRegistry((MappedRegistry)rawGeneratorOptions.m_204655_(), (a, b) -> true));
        try {
            if (this.ip_lastRegistryAccess != null) {
                MinecraftForge.EVENT_BUS.post((Event)new ServerDimensionsLoadEvent(copiedGeneratorOptions, this.ip_lastRegistryAccess));
            } else {
                Helper.err("Null registry access");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashSet dims = new HashSet();
        if (this.ip_lastWorldGenSettings != null) {
            this.ip_lastWorldGenSettings.m_204655_().m_6566_().forEach(id -> dims.add(DimId.idToKey(id)));
        } else {
            Helper.err("Null WorldGen settings");
        }
        copiedGeneratorOptions.m_204655_().m_6566_().forEach(id -> dims.add(DimId.idToKey(id)));
        return dims.stream().toList();
    }

    @Override
    public PackRepository portal_getResourcePackManager() {
        return (PackRepository)this.m_100871_().getSecond();
    }

    @Override
    public DataPackConfig portal_getDataPackSettings() {
        return this.f_100846_;
    }
}

