/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.portal_generation;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.AbstractDiligentForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.peripheral.platform_specific.PeripheralModEntry;

public class PortalHelperForm
extends AbstractDiligentForm {
    public PortalHelperForm() {
        super(true);
    }

    @Override
    public void generateNewFrame(ServerLevel fromWorld, BlockPortalShape fromShape, ServerLevel toWorld, BlockPortalShape toShape) {
        for (BlockPos blockPos : toShape.frameAreaWithoutCorner) {
            toWorld.m_46597_(blockPos, ((Block)PeripheralModEntry.PORTAL_HELPER_BLOCK.get()).m_49966_());
        }
        McHelper.findEntitiesByBox(ServerPlayer.class, (Level)fromWorld, new AABB(fromShape.anchor).m_82400_(10.0), 2.0, e -> true).forEach(player -> player.m_5661_((Component)Component.m_237115_((String)"imm_ptl.portal_helper_not_linked"), false));
    }

    @Override
    public Portal[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        Portal[] portals;
        ServerLevel world = McHelper.getServerWorld(info.from);
        for (BlockPos blockPos : info.fromShape.area) {
            world.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
        }
        world.m_46597_(info.fromShape.firstFramePos, Blocks.f_50016_.m_49966_());
        world.m_46597_(info.toShape.firstFramePos, Blocks.f_50016_.m_49966_());
        Object portal = info.createTemplatePortal((EntityType)IPRegistry.PORTAL.get());
        PortalExtension.get(portal).bindCluster = true;
        Object flipped = PortalManipulation.createFlippedPortal(portal, (EntityType)IPRegistry.PORTAL.get());
        Object reverse = PortalManipulation.createReversePortal(portal, (EntityType)IPRegistry.PORTAL.get());
        Object parallel = PortalManipulation.createReversePortal(flipped, (EntityType)IPRegistry.PORTAL.get());
        for (Portal p : portals = new Portal[]{portal, flipped, reverse, parallel}) {
            McHelper.spawnServerEntity(p);
        }
        return portals;
    }

    @Override
    public Predicate<BlockState> getOtherSideFramePredicate() {
        return blockState -> blockState.m_60734_() == PeripheralModEntry.PORTAL_HELPER_BLOCK.get();
    }

    @Override
    public Predicate<BlockState> getThisSideFramePredicate() {
        return blockState -> blockState.m_60734_() == PeripheralModEntry.PORTAL_HELPER_BLOCK.get();
    }

    @Override
    public Predicate<BlockState> getAreaPredicate() {
        return blockState -> blockState.m_60795_();
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        throw new RuntimeException();
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }
}

