/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class GuiHelper {
    public static LayoutFunc layoutButtonHorizontally(AbstractWidget widget) {
        return (a, b) -> {
            widget.f_93620_ = a;
            widget.m_93674_(b - a);
        };
    }

    public static LayoutFunc layoutRectHorizontally(Rect widget) {
        return (a, b) -> {
            widget.xMin = a;
            widget.xMax = b;
        };
    }

    public static LayoutFunc layoutButtonVertically(AbstractWidget widget) {
        return (a, b) -> {
            widget.f_93621_ = a;
        };
    }

    public static LayoutFunc layoutRectVertically(Rect widget) {
        return (a, b) -> {
            widget.yMin = a;
            widget.yMax = b;
        };
    }

    public static void layout(int from, int to, LayoutElement ... elements) {
        int totalElasticWeight = Arrays.stream(elements).filter(e -> !e.fixedLength).mapToInt(e -> e.length).sum();
        int totalFixedLen = Arrays.stream(elements).filter(e -> e.fixedLength).mapToInt(e -> e.length).sum();
        int totalEscalateLen = to - from - totalFixedLen;
        int currCoordinate = from;
        for (LayoutElement element : elements) {
            int currLen = element.fixedLength ? element.length : element.length * totalEscalateLen / totalElasticWeight;
            element.apply.apply(currCoordinate, currCoordinate + currLen);
            currCoordinate += currLen;
        }
    }

    public static LayoutElement blankSpace(int length) {
        return new LayoutElement(true, length, (a, b) -> {});
    }

    public static LayoutElement elasticBlankSpace() {
        return new LayoutElement(false, 1, (a, b) -> {});
    }

    public static LayoutFunc combine(LayoutFunc ... args) {
        return (from, to) -> {
            for (LayoutFunc layoutFunc : args) {
                layoutFunc.apply(from, to);
            }
        };
    }

    public static LayoutElement elastic(int weight, LayoutFunc layoutFunc) {
        return new LayoutElement(false, weight, layoutFunc);
    }

    public static LayoutElement fixedLength(int length, LayoutFunc layoutFunc) {
        return new LayoutElement(true, length, layoutFunc);
    }

    public static interface LayoutFunc {
        public void apply(int var1, int var2);
    }

    public static class Rect {
        public float xMin;
        public float yMin;
        public float xMax;
        public float yMax;

        public Rect(float xMin, float yMin, float xMax, float yMax) {
            this.xMin = xMin;
            this.yMin = yMin;
            this.xMax = xMax;
            this.yMax = yMax;
        }

        public Rect() {
            this(0.0f, 0.0f, 0.0f, 0.0f);
        }

        public void renderTextCentered(Component text, PoseStack matrixStack) {
            Font textRenderer = Minecraft.m_91087_().f_91062_;
            FormattedCharSequence orderedText = text.m_7532_();
            textRenderer.m_92744_(matrixStack, orderedText, (this.xMin + this.xMax) / 2.0f - (float)textRenderer.m_92724_(orderedText) / 2.0f, this.yMin + 5.0f, -1);
        }

        public void renderTextLeft(Component text, PoseStack matrixStack) {
            Font textRenderer = Minecraft.m_91087_().f_91062_;
            textRenderer.m_92763_(matrixStack, text, this.xMin, this.yMin + 5.0f, -1);
        }
    }

    public static class LayoutElement {
        public boolean fixedLength;
        public int length;
        public LayoutFunc apply;

        public LayoutElement(boolean fixedLength, int length, LayoutFunc apply) {
            this.fixedLength = fixedLength;
            this.length = length;
            this.apply = apply;
        }
    }
}

