/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.module.StructureProcessorModule;
import com.yungnickyoung.minecraft.betterdeserttemples.world.ArmorStandChances;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ArmorStandProcessor
extends StructureProcessor {
    public static final ArmorStandProcessor INSTANCE = new ArmorStandProcessor();
    public static final Codec<StructureProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader levelReader, BlockPos structurePiecePos, StructureTemplate.StructureEntityInfo localEntityInfo, StructureTemplate.StructureEntityInfo globalEntityInfo, StructurePlaceSettings structurePlaceSettings, StructureTemplate template) {
        if (globalEntityInfo.f_74685_.m_128461_("id").equals("minecraft:armor_stand")) {
            String helmet;
            ListTag armorItems = globalEntityInfo.f_74685_.m_128437_("ArmorItems", 10);
            RandomSource randomSource = structurePlaceSettings.m_230326_(globalEntityInfo.f_74684_);
            try {
                helmet = ((CompoundTag)armorItems.get(3)).m_128423_("id").toString();
            }
            catch (Exception e) {
                BetterDesertTemplesCommon.LOGGER.info("Unable to randomize armor stand at {}. Missing helmet?", (Object)globalEntityInfo.f_74684_);
                return globalEntityInfo;
            }
            CompoundTag newNBT = globalEntityInfo.f_74685_.m_6426_();
            if (helmet.equals("\"minecraft:iron_helmet\"")) {
                ListTag armorItemsList = newNBT.m_128437_("ArmorItems", 10);
                String bootsString = Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getArmoryBoots(randomSource)).toString();
                armorItemsList.m_128728_(0).m_128359_("id", bootsString);
                armorItemsList.m_128728_(0).m_128344_("Count", (byte)1);
                armorItemsList.m_128728_(0).m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), compoundTag -> compoundTag.m_128405_("Damage", 0)));
                String leggingsString = Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getArmoryLeggings(randomSource)).toString();
                armorItemsList.m_128728_(1).m_128359_("id", leggingsString);
                armorItemsList.m_128728_(1).m_128344_("Count", (byte)1);
                armorItemsList.m_128728_(1).m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), compoundTag -> compoundTag.m_128405_("Damage", 0)));
                String chestplateString = Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getArmoryChestplate(randomSource)).toString();
                armorItemsList.m_128728_(2).m_128359_("id", chestplateString);
                armorItemsList.m_128728_(2).m_128344_("Count", (byte)1);
                armorItemsList.m_128728_(2).m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), compoundTag -> compoundTag.m_128405_("Damage", 0)));
                String helmetString = Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getArmoryHelmet(randomSource)).toString();
                armorItemsList.m_128728_(3).m_128359_("id", helmetString);
                armorItemsList.m_128728_(3).m_128344_("Count", (byte)1);
                armorItemsList.m_128728_(3).m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), compoundTag -> compoundTag.m_128405_("Damage", 0)));
            } else if (helmet.equals("\"minecraft:leather_helmet\"")) {
                ListTag armorItemsList = newNBT.m_128437_("ArmorItems", 10);
                String bootsString = Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getWardrobeBoots(randomSource)).toString();
                armorItemsList.m_128728_(0).m_128359_("id", bootsString);
                armorItemsList.m_128728_(0).m_128344_("Count", (byte)1);
                armorItemsList.m_128728_(0).m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), compoundTag -> compoundTag.m_128405_("Damage", 0)));
                String leggingsString = Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getWardrobeLeggings(randomSource)).toString();
                armorItemsList.m_128728_(1).m_128359_("id", leggingsString);
                armorItemsList.m_128728_(1).m_128344_("Count", (byte)1);
                armorItemsList.m_128728_(1).m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), compoundTag -> compoundTag.m_128405_("Damage", 0)));
                String chestplateString = Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getWardrobeChestplate(randomSource)).toString();
                armorItemsList.m_128728_(2).m_128359_("id", chestplateString);
                armorItemsList.m_128728_(2).m_128344_("Count", (byte)1);
                armorItemsList.m_128728_(2).m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), compoundTag -> compoundTag.m_128405_("Damage", 0)));
                String helmetString = Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getWardrobeHelmet(randomSource)).toString();
                armorItemsList.m_128728_(3).m_128359_("id", helmetString);
                armorItemsList.m_128728_(3).m_128344_("Count", (byte)1);
                armorItemsList.m_128728_(3).m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), compoundTag -> compoundTag.m_128405_("Damage", 0)));
            } else {
                BetterDesertTemplesCommon.LOGGER.info("Armor stand at {} has invalid helmet. Found: {}", (Object)globalEntityInfo.f_74684_, (Object)helmet);
                return globalEntityInfo;
            }
            globalEntityInfo = new StructureTemplate.StructureEntityInfo(globalEntityInfo.f_74683_, globalEntityInfo.f_74684_, newNBT);
        }
        return globalEntityInfo;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorModule.ARMOR_STAND_PROCESSOR;
    }
}

