/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.item.BlockTypeBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEntrySet<T extends BlockType, B extends Block>
extends AbstractSimpleEntrySet<T, B, Item> {
    protected final Supplier<@Nullable B> baseBlock;
    protected final Function<T, @Nullable B> blockFactory;
    @Nullable
    protected final @Nullable TriFunction<T, B, // Could not load outer class - annotation placement on inner may be incorrect
    Item.Properties, @Nullable Item> itemFactory;
    @Nullable
    protected final ITileHolder<?> tileHolder;
    protected final LootTableMode lootMode;
    @Nullable
    protected final Supplier<Supplier<RenderType>> renderType;
    protected static final boolean YEET_JSONS = true;
    protected static final Set<Block> SIMPLE_DROPS = new HashSet<Block>();

    public SimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<@Nullable B> baseBlock, Supplier<T> baseType, Supplier<CreativeModeTab> tab, LootTableMode lootMode, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable ITileHolder<?> tileFactory, @Nullable Supplier<Supplier<RenderType>> renderType, @Nullable @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, Predicate<T> condition) {
        super(type, name, prefix, baseType, tab, paletteSupplier, extraTransform, condition);
        this.blockFactory = blockSupplier;
        this.tileHolder = tileFactory;
        this.lootMode = lootMode;
        this.baseBlock = baseBlock;
        this.itemFactory = itemFactory;
        this.renderType = renderType;
    }

    @Override
    protected Map<T, ? extends ItemLike> getMainEntryMap() {
        return this.blocks;
    }

    public ITileHolder<?> getTileHolder() {
        return this.tileHolder;
    }

    public <E extends BlockEntity> BlockEntityType<E> getTIle(Class<E> tileClass) {
        Preconditions.checkNotNull(this.tileHolder, (Object)"Entry set has no tile entity!");
        return this.tileHolder.get();
    }

    @Override
    public boolean isDisabled() {
        return this.getBaseBlock() == null;
    }

    public B getBaseBlock() {
        return (B)((Block)this.baseBlock.get());
    }

    @Override
    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(new ResourceLocation(woodFrom, wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Override
    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void addTranslations(CompatModule module, AfterLanguageLoadEvent lang) {
        this.blocks.forEach((w, v) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)("block_type." + module.getModId() + "." + this.typeName), (BlockType)w, (Block)v));
    }

    @Override
    public void registerWoodBlocks(CompatModule module, Registrator<Block> registry, Collection<WoodType> woodTypes) {
        if (WoodType.class == this.getTypeClass()) {
            this.registerBlocks(module, registry, woodTypes);
        }
    }

    @Override
    public void registerLeavesBlocks(CompatModule module, Registrator<Block> registry, Collection<LeavesType> leavesTypes) {
        if (LeavesType.class == this.getTypeClass()) {
            this.registerBlocks(module, registry, leavesTypes);
        }
    }

    @Override
    public void registerBlocks(CompatModule module, Registrator<Block> registry, Collection<T> woodTypes) {
        if (this.isDisabled()) {
            return;
        }
        B base = this.getBaseBlock();
        if (base == null || base == Blocks.f_50016_) {
            throw new UnsupportedOperationException("Base block cant be null (" + this.typeName + " for " + module.modId + " module)");
        }
        ((BlockType)this.baseType.get()).addChild(this.getChildKey(module), base);
        for (BlockType w : woodTypes) {
            Block block;
            String name = this.getBlockName(w);
            String fullName = module.shortenedId() + "/" + w.getNamespace() + "/" + name;
            if (w.isVanilla() || module.isEntryAlreadyRegistered(name, w, (Registry<?>)Registry.f_122824_) || !this.condition.test(w) || (block = (Block)this.blockFactory.apply(w)) == null) continue;
            this.blocks.put(w, block);
            registry.register(EveryCompat.res(fullName), (Object)block);
            w.addChild(this.getChildKey(module), (Object)block);
            if (this.lootMode != LootTableMode.DROP_SELF) continue;
            SIMPLE_DROPS.add(block);
        }
    }

    @NotNull
    public String getBlockName(T w) {
        String name;
        if (this.prefix != null) {
            name = this.prefix + "_" + w.getTypeName();
            if (!this.postfix.isEmpty()) {
                name = name + "_" + this.postfix;
            }
        } else {
            name = w.getTypeName() + "_" + this.postfix;
        }
        return name;
    }

    @Override
    public void registerItems(CompatModule module, Registrator<Item> registry) {
        this.blocks.forEach((w, value) -> {
            CreativeModeTab tab = this.getTab(w, value);
            Object i = this.itemFactory != null ? (Item)this.itemFactory.apply(w, value, (Object)new Item.Properties().m_41491_(tab)) : new BlockTypeBasedBlockItem(value, new Item.Properties().m_41491_(tab), w);
            if (i != null) {
                this.items.put(w, i);
                registry.register(Utils.getID((Block)value), i);
            }
        });
    }

    @Override
    public void registerTiles(CompatModule module, Registrator<BlockEntityType<?>> registry) {
        if (this.isDisabled()) {
            return;
        }
        ITileHolder<?> iTileHolder = this.tileHolder;
        if (iTileHolder instanceof NewTileHolder) {
            NewTileHolder nt = (NewTileHolder)iTileHolder;
            BlockEntityType tile = nt.createInstance((Block[])this.blocks.values().toArray(Block[]::new));
            registry.register(EveryCompat.res(module.shortenedId() + "_" + this.getName()), tile);
        }
    }

    @Override
    public void registerEntityRenderers(CompatModule simpleModule, ClientPlatformHelper.BlockEntityRendererEvent event) {
        if (this.tileHolder != null) {
            // empty if block
        }
    }

    @Override
    public void setupExistingTiles() {
        if (this.isDisabled()) {
            return;
        }
        ITileHolder<?> iTileHolder = this.tileHolder;
        if (iTileHolder instanceof ExistingTileHolder) {
            ExistingTileHolder et = (ExistingTileHolder)iTileHolder;
            SimpleModule.appendTileEntityBlocks(et.get(), this.blocks.values());
        }
    }

    @Override
    public void setRenderLayer() {
        if (this.isDisabled()) {
            return;
        }
        if (this.renderType != null) {
            this.blocks.values().forEach(t -> ClientPlatformHelper.registerRenderType((Block)t, (RenderType)this.renderType.get().get()));
        }
    }

    @Override
    public void generateLootTables(CompatModule module, DynamicDataPack pack, ResourceManager manager) {
        if (this.isDisabled()) {
            return;
        }
        if (this.lootMode == LootTableMode.COPY_FROM_PARENT) {
            ResourceLocation reg = Utils.getID(this.getBaseBlock());
            ResourcesUtils.addBlockResources(module.getModId(), manager, (DynamicResourcePack)pack, this.blocks, ((BlockType)this.baseType.get()).getTypeName(), ResType.BLOCK_LOOT_TABLES.getPath(reg));
        } else if (this.lootMode == LootTableMode.DROP_SELF) {
            // empty if block
        }
    }

    @Override
    public void generateModels(CompatModule module, DynClientResourcesProvider handler, ResourceManager manager) {
        if (this.isDisabled()) {
            return;
        }
        ResourcesUtils.addStandardResources(module.getModId(), manager, handler, this.blocks, (BlockType)this.baseType.get(), this.extraTransform);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> builder(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> builder(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    public static boolean isSimpleDrop(Block block) {
        return SIMPLE_DROPS.contains(block);
    }

    private static /* synthetic */ void lambda$generateLootTables$4(DynamicDataPack pack, BlockType wood, Block value) {
        pack.addSimpleBlockLootTable(value);
    }

    public static interface ITileHolder<H extends BlockEntity> {
        public BlockEntityType<? extends H> get();
    }

    public static enum LootTableMode {
        DROP_SELF,
        COPY_FROM_PARENT,
        NO_LOOT;

    }

    public static class NewTileHolder<H extends BlockEntity>
    implements ITileHolder<H> {
        protected final BiFunction<BlockPos, BlockState, H> tileFactory;
        protected Supplier<BlockEntityRendererProvider<H>> renderer = null;
        public BlockEntityType<? extends H> tile = null;

        public NewTileHolder(BiFunction<BlockPos, BlockState, H> tileFactory) {
            this.tileFactory = tileFactory;
        }

        @Override
        public BlockEntityType<? extends H> get() {
            return this.tile;
        }

        public BlockEntityType<? extends H> createInstance(Block ... blocks) {
            if (this.tile != null) {
                throw new UnsupportedOperationException("tile has already been created");
            }
            this.tile = PlatformHelper.newBlockEntityType(this.tileFactory::apply, (Block[])blocks);
            return this.tile;
        }
    }

    public record ExistingTileHolder<H extends BlockEntity>(Supplier<BlockEntityType<H>> supplier) implements ITileHolder<H>
    {
        @Override
        public BlockEntityType<? extends H> get() {
            return this.supplier.get();
        }
    }

    public static class Builder<T extends BlockType, B extends Block>
    extends AbstractSimpleEntrySet.Builder<Builder<T, B>, T, B, Item> {
        protected final Supplier<@Nullable B> baseBlock;
        protected LootTableMode lootMode = LootTableMode.DROP_SELF;
        protected final Function<T, B> blockFactory;
        @Nullable
        protected TriFunction<T, B, Item.Properties, Item> itemFactory;
        @Nullable
        protected ITileHolder<?> tileHolder;
        @Nullable
        protected Supplier<Supplier<RenderType>> renderType = null;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            super(type, name, prefix, baseType);
            this.baseBlock = baseBlock;
            this.blockFactory = blockFactory;
        }

        public SimpleEntrySet<T, B> build() {
            SimpleEntrySet<T, B> e = new SimpleEntrySet<T, B>(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.lootMode, this.itemFactory, this.tileHolder, this.renderType, this.palette, this.extraModelTransform, this.condition);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }

        public <H extends BlockEntity> Builder<T, B> addTile(Supplier<BlockEntityType<H>> tile) {
            this.tileHolder = new ExistingTileHolder(tile);
            return this;
        }

        public <H extends BlockEntity> Builder<T, B> addTile(BiFunction<BlockPos, BlockState, H> tileFactory) {
            this.tileHolder = new NewTileHolder(tileFactory);
            return this;
        }

        public Builder<T, B> addCustomItem(TriFunction<T, B, Item.Properties, Item> itemFactory) {
            this.itemFactory = itemFactory;
            return this;
        }

        public Builder<T, B> noItem() {
            this.itemFactory = (a, b, c) -> null;
            return this;
        }

        public Builder<T, B> copyParentDrop() {
            this.lootMode = LootTableMode.COPY_FROM_PARENT;
            return this;
        }

        public Builder<T, B> dropSelf() {
            this.lootMode = LootTableMode.DROP_SELF;
            return this;
        }

        public Builder<T, B> noDrops() {
            this.lootMode = LootTableMode.NO_LOOT;
            return this;
        }

        public Builder<T, B> setRenderType(Supplier<Supplier<RenderType>> renderType) {
            this.renderType = renderType;
            return this;
        }

        public Builder<T, B> defaultRecipe() {
            this.recipes.add(() -> Utils.getID((Block)((Block)this.baseBlock.get())));
            return this;
        }
    }
}

