/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.forge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class CustomRecipeLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final int PATH_SUFFIX_LENGTH = ".json".length();

    private CustomRecipeLoader() {
        super(GSON, "template_recipes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        CustomRecipeLoader.loadRecipes(jsons);
    }

    private static void loadRecipes(Map<ResourceLocation, JsonElement> jsons) {
        int added = 0;
        boolean oldStatus = ((DynamicDataPack)ServerDynamicResourcesHandler.INSTANCE.getPack()).generateDebugResources;
        ((DynamicDataPack)ServerDynamicResourcesHandler.INSTANCE.getPack()).generateDebugResources = true;
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            try {
                JsonElement jsonElement = j.getValue();
                if (!(jsonElement instanceof JsonObject)) continue;
                JsonObject jo = (JsonObject)jsonElement;
                IRecipeTemplate template = TemplateRecipeManager.read((JsonObject)jo);
                boolean ad = false;
                for (WoodType w : WoodTypeRegistry.getTypes()) {
                    if (w == WoodTypeRegistry.OAK_TYPE) continue;
                    ResourceLocation res = EveryCompat.res(w.getAppendableId() + j.getKey().m_135815_());
                    FinishedRecipe newR = template.createSimilar((BlockType)WoodTypeRegistry.OAK_TYPE, (BlockType)w, w.planks.m_5456_(), res.toString());
                    ((DynamicDataPack)ServerDynamicResourcesHandler.INSTANCE.getPack()).addRecipe(newR);
                    if (ad) continue;
                    ad = true;
                    ++added;
                }
            }
            catch (Exception e) {
                EveryCompat.LOGGER.warn("Failed to add custom recipe for wood types. Be sure it is based off oak wood:", (Throwable)e);
            }
        }
        ((DynamicDataPack)ServerDynamicResourcesHandler.INSTANCE.getPack()).generateDebugResources = oldStatus;
        if (added != 0) {
            EveryCompat.LOGGER.info("Added {} Custom Recipes for all {} wood types", (Object)added, (Object)WoodTypeRegistry.getTypes().size());
        }
    }
}

