/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.aocalc;

import java.lang.reflect.Constructor;
import java.util.BitSet;
import java.util.function.Supplier;
import link.infra.indium.Indium;
import link.infra.indium.mixin.renderer.AccessAmbientOcclusionCalculator;
import link.infra.indium.renderer.accessor.AccessBlockModelRenderer;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class VanillaAoHelper {
    private static Supplier<AccessAmbientOcclusionCalculator> factory;
    private static AccessBlockModelRenderer blockRenderer;

    public static void initialize(ModelBlockRenderer instance) {
        blockRenderer = (AccessBlockModelRenderer)instance;
        for (Class<?> innerClass : ModelBlockRenderer.class.getDeclaredClasses()) {
            if (!innerClass.getName().contains("AmbientOcclusionFace")) continue;
            final Constructor<?> constructor = innerClass.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            factory = new Supplier<AccessAmbientOcclusionCalculator>(){

                @Override
                public AccessAmbientOcclusionCalculator get() {
                    try {
                        return (AccessAmbientOcclusionCalculator)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        Indium.LOGGER.warn("[Reforgium] Exception accessing vanilla smooth lighter", (Throwable)e);
                        return null;
                    }
                }
            };
            break;
        }
        if (factory != null && factory.get() == null) {
            factory = null;
        }
        if (factory == null) {
            Indium.LOGGER.warn("[Reforgium] Vanilla smooth lighter unavailable. Reforgium lighter will be used even if not configured.");
        }
    }

    public static AccessAmbientOcclusionCalculator get() {
        return factory == null ? null : factory.get();
    }

    public static void getQuadDimensions(BlockAndTintGetter blockRenderView, BlockState blockState, BlockPos pos, int[] vertexData, Direction face, float[] aoData, BitSet controlBits) {
        blockRenderer.indium$getQuadDimensions(blockRenderView, blockState, pos, vertexData, face, aoData, controlBits);
    }
}

