/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Function;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public abstract class ChunkQuadBufferer
implements BaseQuadRenderer.QuadBufferer {
    protected final Function<RenderType, ChunkModelBuilder> builderFunc;

    protected abstract Vec3i origin();

    protected abstract Vec3 blockOffset();

    ChunkQuadBufferer(Function<RenderType, ChunkModelBuilder> builderFunc) {
        this.builderFunc = builderFunc;
    }

    @Override
    public void bufferQuad(MutableQuadViewImpl quad, RenderType renderLayer) {
        ChunkQuadBufferer.bufferQuad(this.builderFunc.apply(renderLayer), quad, this.origin(), this.blockOffset());
    }

    public static void bufferQuad(ChunkModelBuilder builder, MutableQuadViewImpl quad, Vec3i origin, Vec3 blockOffset) {
        ModelVertexSink vertices = builder.getVertexSink();
        vertices.ensureCapacity(4);
        Direction cullFace = quad.cullFace();
        IndexBufferBuilder indices = builder.getIndexBufferBuilder(cullFace != null ? ModelQuadFacing.fromDirection((Direction)cullFace) : ModelQuadFacing.UNASSIGNED);
        int vertexStart = vertices.getVertexCount();
        for (int i = 0; i < 4; ++i) {
            float x = quad.x(i) + (float)blockOffset.m_7096_();
            float y = quad.y(i) + (float)blockOffset.m_7098_();
            float z = quad.z(i) + (float)blockOffset.m_7094_();
            int color = quad.spriteColor(i, 0);
            color = ColorABGR.pack((int)(color & 0xFF), (int)(color >> 8 & 0xFF), (int)(color >> 16 & 0xFF), (int)(color >> 24 & 0xFF));
            float u = quad.spriteU(i, 0);
            float v = quad.spriteV(i, 0);
            int lm = quad.lightmap(i);
            vertices.writeVertex(origin, x, y, z, color, u, v, lm, builder.getChunkId());
        }
        indices.add(vertexStart, ModelQuadWinding.CLOCKWISE);
        TextureAtlasSprite sprite = quad.cachedSprite();
        if (sprite == null) {
            sprite = SpriteFinderCache.forBlockAtlas().find(quad, 0);
        }
        builder.addSprite(sprite);
        vertices.flush();
    }
}

