/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractQuadRenderer {
    protected final Function<RenderType, VertexConsumer> bufferFunc;
    protected final BlockRenderInfo blockInfo;
    protected final AoCalculator aoCalc;
    protected final RenderContext.QuadTransform transform;
    protected final Vector3f normalVec = new Vector3f();
    private final BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();

    protected abstract Matrix4f matrix();

    protected abstract Matrix3f normalMatrix();

    protected abstract int overlay();

    AbstractQuadRenderer(BlockRenderInfo blockInfo, Function<RenderType, VertexConsumer> bufferFunc, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        this.blockInfo = blockInfo;
        this.bufferFunc = bufferFunc;
        this.aoCalc = aoCalc;
        this.transform = transform;
    }

    protected void renderQuad(MutableQuadViewImpl quad, boolean isVanilla) {
        if (!this.transform.transform(quad)) {
            return;
        }
        if (!this.blockInfo.shouldDrawFace(quad.cullFace())) {
            return;
        }
        this.tessellateQuad(quad, 0, isVanilla);
    }

    private void tessellateQuad(MutableQuadViewImpl quad, int textureIndex, boolean isVanilla) {
        RenderMaterialImpl.Value mat = quad.material();
        int colorIndex = mat.disableColorIndex(textureIndex) ? -1 : quad.colorIndex();
        RenderType renderLayer = this.blockInfo.effectiveRenderLayer(mat.blendMode(textureIndex));
        if (this.blockInfo.defaultAo && !mat.disableAo(textureIndex)) {
            this.aoCalc.compute(quad, isVanilla);
            if (mat.emissive(textureIndex)) {
                this.tessellateSmoothEmissive(quad, renderLayer, colorIndex);
            } else {
                this.tessellateSmooth(quad, renderLayer, colorIndex);
            }
        } else if (mat.emissive(textureIndex)) {
            this.tessellateFlatEmissive(quad, renderLayer, colorIndex);
        } else {
            this.tessellateFlat(quad, renderLayer, colorIndex);
        }
    }

    private void colorizeQuad(MutableQuadViewImpl q, int blockColorIndex) {
        if (blockColorIndex == -1) {
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(q.spriteColor(i, 0)));
            }
        } else {
            int blockColor = this.blockInfo.blockColor(blockColorIndex);
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(ColorHelper.multiplyColor(blockColor, q.spriteColor(i, 0))));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, RenderType renderLayer) {
        AbstractQuadRenderer.bufferQuad(this.bufferFunc.apply(renderLayer), quad, this.matrix(), this.overlay(), this.normalMatrix(), this.normalVec);
    }

    public static void bufferQuad(VertexConsumer buff, MutableQuadViewImpl quad, Matrix4f matrix, int overlay, Matrix3f normalMatrix, Vector3f normalVec) {
        boolean useNormals = quad.hasVertexNormals();
        if (useNormals) {
            quad.populateMissingNormals();
        } else {
            Vector3f faceNormal = quad.faceNormal();
            normalVec.m_122245_(faceNormal.m_122239_(), faceNormal.m_122260_(), faceNormal.m_122269_());
            normalVec.m_122249_(normalMatrix);
        }
        for (int i = 0; i < 4; ++i) {
            buff.m_85982_(matrix, quad.x(i), quad.y(i), quad.z(i));
            int color = quad.spriteColor(i, 0);
            buff.m_6122_(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF, color >> 24 & 0xFF);
            buff.m_7421_(quad.spriteU(i, 0), quad.spriteV(i, 0));
            buff.m_86008_(overlay);
            buff.m_85969_(quad.lightmap(i));
            if (useNormals) {
                normalVec.m_122245_(quad.normalX(i), quad.normalY(i), quad.normalZ(i));
                normalVec.m_122249_(normalMatrix);
            }
            buff.m_5601_(normalVec.m_122239_(), normalVec.m_122260_(), normalVec.m_122269_());
            buff.m_5752_();
        }
    }

    protected void tessellateSmooth(MutableQuadViewImpl q, RenderType renderLayer, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), this.aoCalc.ao[i]));
            q.lightmap(i, ColorHelper.maxBrightness(q.lightmap(i), this.aoCalc.light[i]));
        }
        this.bufferQuad(q, renderLayer);
    }

    protected void tessellateSmoothEmissive(MutableQuadViewImpl q, RenderType renderLayer, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), this.aoCalc.ao[i]));
            q.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(q, renderLayer);
    }

    protected void tessellateFlat(MutableQuadViewImpl quad, RenderType renderLayer, int blockColorIndex) {
        this.colorizeQuad(quad, blockColorIndex);
        this.shadeFlatQuad(quad);
        int brightness = this.flatBrightness(quad, this.blockInfo.blockState, this.blockInfo.blockPos);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), brightness));
        }
        this.bufferQuad(quad, renderLayer);
    }

    protected void tessellateFlatEmissive(MutableQuadViewImpl quad, RenderType renderLayer, int blockColorIndex) {
        this.colorizeQuad(quad, blockColorIndex);
        this.shadeFlatQuad(quad);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(quad, renderLayer);
    }

    int flatBrightness(MutableQuadViewImpl quad, BlockState blockState, BlockPos pos) {
        this.mpos.m_122190_((Vec3i)pos);
        if (quad.cullFace() != null) {
            this.mpos.m_122173_(quad.cullFace());
        } else {
            int flags = quad.geometryFlags();
            if ((flags & 4) != 0 || (flags & 2) != 0 && blockState.m_60838_((BlockGetter)this.blockInfo.blockView, pos)) {
                this.mpos.m_122173_(quad.lightFace());
            }
        }
        return LevelRenderer.m_109537_((BlockAndTintGetter)this.blockInfo.blockView, (BlockState)blockState, (BlockPos)this.mpos);
    }

    private void shadeFlatQuad(MutableQuadViewImpl quad) {
        block3: {
            block2: {
                if (!quad.hasVertexNormals()) break block2;
                float faceShade = this.blockInfo.blockView.m_7717_(quad.lightFace(), quad.hasShade());
                for (int i = 0; i < 4; ++i) {
                    quad.spriteColor(i, 0, ColorHelper.multiplyRGB(quad.spriteColor(i, 0), this.vertexShade(quad, i, faceShade)));
                }
                break block3;
            }
            float diffuseShade = this.blockInfo.blockView.m_7717_(quad.lightFace(), quad.hasShade());
            if (diffuseShade == 1.0f) break block3;
            for (int i = 0; i < 4; ++i) {
                quad.spriteColor(i, 0, ColorHelper.multiplyRGB(quad.spriteColor(i, 0), diffuseShade));
            }
        }
    }

    private float vertexShade(MutableQuadViewImpl quad, int vertexIndex, float faceShade) {
        return quad.hasNormal(vertexIndex) ? this.normalShade(quad.normalX(vertexIndex), quad.normalY(vertexIndex), quad.normalZ(vertexIndex), quad.hasShade()) : faceShade;
    }

    private float normalShade(float normalX, float normalY, float normalZ, boolean hasShade) {
        float sum = 0.0f;
        float div = 0.0f;
        if (normalX > 0.0f) {
            sum += normalX * this.blockInfo.blockView.m_7717_(Direction.EAST, hasShade);
            div += normalX;
        } else if (normalX < 0.0f) {
            sum += -normalX * this.blockInfo.blockView.m_7717_(Direction.WEST, hasShade);
            div -= normalX;
        }
        if (normalY > 0.0f) {
            sum += normalY * this.blockInfo.blockView.m_7717_(Direction.UP, hasShade);
            div += normalY;
        } else if (normalY < 0.0f) {
            sum += -normalY * this.blockInfo.blockView.m_7717_(Direction.DOWN, hasShade);
            div -= normalY;
        }
        if (normalZ > 0.0f) {
            sum += normalZ * this.blockInfo.blockView.m_7717_(Direction.SOUTH, hasShade);
            div += normalZ;
        } else if (normalZ < 0.0f) {
            sum += -normalZ * this.blockInfo.blockView.m_7717_(Direction.NORTH, hasShade);
            div -= normalZ;
        }
        return sum / div;
    }
}

