/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Set;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class ChunkRenderInfo {
    private final Long2IntOpenHashMap brightnessCache;
    private final Long2FloatOpenHashMap aoLevelCache;
    private final BlockPos.MutableBlockPos chunkOrigin = new BlockPos.MutableBlockPos();
    ChunkRenderDispatcher.RenderChunk.RebuildTask.CompileResults renderData;
    ChunkRenderDispatcher.RenderChunk chunkRenderer;
    ChunkBufferBuilderPack builders;
    Set<RenderType> initializedLayers;
    BlockAndTintGetter blockView;
    private final Object2ObjectOpenHashMap<RenderType, BufferBuilder> buffers = new Object2ObjectOpenHashMap();

    ChunkRenderInfo() {
        this.brightnessCache = new Long2IntOpenHashMap();
        this.brightnessCache.defaultReturnValue(Integer.MAX_VALUE);
        this.aoLevelCache = new Long2FloatOpenHashMap();
        this.aoLevelCache.defaultReturnValue(Float.MAX_VALUE);
    }

    void prepare(RenderChunkRegion blockView, ChunkRenderDispatcher.RenderChunk chunkRenderer, ChunkRenderDispatcher.RenderChunk.RebuildTask.CompileResults renderData, ChunkBufferBuilderPack builders, Set<RenderType> initializedLayers) {
        this.blockView = blockView;
        this.chunkOrigin.m_122190_((Vec3i)chunkRenderer.m_112839_());
        this.renderData = renderData;
        this.chunkRenderer = chunkRenderer;
        this.builders = builders;
        this.initializedLayers = initializedLayers;
        this.buffers.clear();
        this.brightnessCache.clear();
        this.aoLevelCache.clear();
    }

    void release() {
        this.renderData = null;
        this.chunkRenderer = null;
        this.buffers.clear();
    }

    public BufferBuilder getInitializedBuffer(RenderType renderLayer) {
        BufferBuilder builder = (BufferBuilder)this.buffers.get((Object)renderLayer);
        if (builder == null) {
            builder = this.builders.m_108839_(renderLayer);
            if (this.initializedLayers.add(renderLayer)) {
                this.chunkRenderer.m_112805_(builder);
            }
            this.buffers.put((Object)renderLayer, (Object)builder);
        }
        return builder;
    }

    int cachedBrightness(BlockPos pos, BlockState state) {
        long key = pos.m_121878_();
        int result = this.brightnessCache.get(key);
        if (result == Integer.MAX_VALUE) {
            result = LevelRenderer.m_109537_((BlockAndTintGetter)this.blockView, (BlockState)state, (BlockPos)pos);
            this.brightnessCache.put(key, result);
        }
        return result;
    }

    float cachedAoLevel(BlockPos pos, BlockState state) {
        long key = pos.m_121878_();
        float result = this.aoLevelCache.get(key);
        if (result == Float.MAX_VALUE) {
            result = AoLuminanceFix.INSTANCE.apply((BlockGetter)this.blockView, pos, state);
            this.aoLevelCache.put(key, result);
        }
        return result;
    }
}

