/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.renderer.client;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultiPartBakedModel.class})
public class MultipartBakedModelMixin
implements FabricBakedModel {
    @Shadow
    @Final
    private List<Pair<Predicate<BlockState>, BakedModel>> f_119459_;
    @Shadow
    @Final
    private Map<BlockState, BitSet> f_119460_;
    @Unique
    boolean isVanilla = true;

    @Override
    public boolean isVanillaAdapter() {
        return this.isVanilla;
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void onInit(List<Pair<Predicate<BlockState>, BakedModel>> components, CallbackInfo cb) {
        for (Pair<Predicate<BlockState>, BakedModel> component : components) {
            if (((FabricBakedModel)component.getRight()).isVanillaAdapter()) continue;
            this.isVanilla = false;
            break;
        }
    }

    @Override
    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        BitSet bitSet = this.f_119460_.get(state);
        if (bitSet == null) {
            bitSet = new BitSet();
            for (int i = 0; i < this.f_119459_.size(); ++i) {
                Pair<Predicate<BlockState>, BakedModel> pair = this.f_119459_.get(i);
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                ((FabricBakedModel)pair.getRight()).emitBlockQuads(blockView, state, pos, randomSupplier, context);
                bitSet.set(i);
            }
            this.f_119460_.put(state, bitSet);
        } else {
            for (int i = 0; i < this.f_119459_.size(); ++i) {
                if (!bitSet.get(i)) continue;
                ((FabricBakedModel)this.f_119459_.get(i).getRight()).emitBlockQuads(blockView, state, pos, randomSupplier, context);
            }
        }
    }

    @Override
    public void emitItemQuads(ItemStack stack, Supplier<RandomSource> randomSupplier, RenderContext context) {
    }
}

