/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.config.CommentedEnum;
import com.stereowalker.unionlib.config.ConfigClassBuilder;
import com.stereowalker.unionlib.config.ConfigHolder;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.config.ConfigObjectBuilder;
import com.stereowalker.unionlib.config.UnionConfig;
import com.stereowalker.unionlib.util.Executor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class ConfigBuilder {
    static Map<String, ConfigHolder<?>> client_values = new HashMap();
    static Map<String, ConfigHolder<?>> common_values = new HashMap();
    static Map<String, ConfigHolder<?>> server_values = new HashMap();
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    protected static void read(Class<?> classs, Object object, ModConfig.Type ... readOnly) {
        ArrayList types = Lists.newArrayList((Object[])readOnly);
        if (classs.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = classs.getAnnotation(UnionConfig.class);
            for (Field field : classs.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || readOnly.length != 0 && !types.contains(configEntry.type())) continue;
                try {
                    if (field.getName().equals("config_button")) {
                        UnionLib.debug("Field: " + field.getName() + ", Value: " + field.get(object) + ", Config: " + ConfigBuilder.getConfigValue(config, configEntry).get());
                    }
                    if (ConfigBuilder.getConfigValue(config, configEntry).get() instanceof Double && field.get(object) instanceof Float) {
                        field.set(object, Float.valueOf(((Double)ConfigBuilder.getConfigValue(config, configEntry).get()).floatValue()));
                    } else {
                        field.set(object, ConfigBuilder.getConfigValue(config, configEntry).get());
                    }
                    if (!field.getName().equals("config_button")) continue;
                    UnionLib.debug("Field: " + field.getName() + ", Value: " + field.get(object) + ", Config: " + ConfigBuilder.getConfigValue(config, configEntry).get());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void init(Class<?> classs, Object object, Init server, Init common, Init client, Executor d) {
        UnionConfig config = classs.getAnnotation(UnionConfig.class);
        for (Field field : classs.getFields()) {
            UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
            if (configEntry == null) continue;
            ModConfig.Type type = configEntry.type() != null ? configEntry.type() : ModConfig.Type.COMMON;
            List<ConfigHolder<?>> holders = common.holders;
            ForgeConfigSpec.Builder builder = common.builder;
            String filename = common.filename;
            if (type == ModConfig.Type.CLIENT) {
                builder = client.builder;
                holders = client.holders;
                filename = client.filename;
            } else if (type == ModConfig.Type.SERVER) {
                builder = server.builder;
                holders = server.holders;
                filename = server.filename;
            } else {
                builder = common.builder;
                holders = common.holders;
                filename = server.filename;
            }
            try {
                ForgeConfigSpec.ConfigValue conf;
                boolean useSlider = false;
                Object enumComment = "";
                if (field.get(object) instanceof CommentedEnum && field.get(object) instanceof Enum) {
                    enumComment = ((CommentedEnum)field.get(object)).getConfigComment();
                }
                enumComment = (String)enumComment + "\n";
                String j = "\n###########################################";
                String k = "\n-------------------------------------------";
                String h = j + "\n";
                Object comment = "";
                ArrayList<Component> saved_comment = new ArrayList<Component>();
                if (field.isAnnotationPresent(UnionConfig.Comment.class)) {
                    void var24_27;
                    String string = field.getAnnotation(UnionConfig.Comment.class).comment()[0];
                    if (field.getAnnotation(UnionConfig.Comment.class).comment().length > 1) {
                        for (int i = 1; i < field.getAnnotation(UnionConfig.Comment.class).comment().length; ++i) {
                            String string2 = (String)var24_27 + "\n" + field.getAnnotation(UnionConfig.Comment.class).comment()[i];
                        }
                    }
                    comment = h + (String)var24_27 + k + (String)enumComment + "Default: " + field.get(object) + k;
                    for (String s : var24_27.split("\n")) {
                        saved_comment.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.AQUA));
                    }
                    String[] i = ((String)enumComment).split("\n");
                    int n = i.length;
                    for (int i2 = 0; i2 < n; ++i2) {
                        String s;
                        s = i[i2];
                        saved_comment.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.YELLOW));
                    }
                    saved_comment.add((Component)Component.m_237113_((String)("Default: " + field.get(object))).m_130940_(ChatFormatting.GREEN));
                } else {
                    comment = h + (String)enumComment + "Default: " + field.get(object) + k;
                    for (String s : ((String)enumComment).split("\n")) {
                        saved_comment.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.YELLOW));
                    }
                    saved_comment.add((Component)Component.m_237113_((String)("Default: " + field.get(object))).m_130940_(ChatFormatting.GREEN));
                }
                ForgeConfigSpec.Builder builder2 = builder.comment((String)comment);
                Double min = 0.0;
                Double max = 0.0;
                if (field.get(object) instanceof Boolean) {
                    conf = builder2.define(ConfigBuilder.configName(configEntry, "Boolean"), (Object)((Boolean)field.get(object)));
                } else if (field.get(object) instanceof Enum) {
                    Enum defaultValue = (Enum)field.get(object);
                    List<Enum> acceptableValues = Arrays.asList((Enum[])defaultValue.getDeclaringClass().getEnumConstants());
                    conf = builder2.defineEnum(ConfigBuilder.split(ConfigBuilder.configName(configEntry, "Enum")), Enum.valueOf(defaultValue.getDeclaringClass(), defaultValue.name()), EnumGetMethod.NAME_IGNORECASE, obj -> {
                        if (obj instanceof Enum) {
                            return acceptableValues.contains(obj);
                        }
                        if (obj == null) {
                            return false;
                        }
                        try {
                            return acceptableValues.contains(EnumGetMethod.NAME_IGNORECASE.get(obj, defaultValue.getDeclaringClass()));
                        }
                        catch (ClassCastException | IllegalArgumentException e) {
                            return false;
                        }
                    });
                } else if (field.get(object) instanceof String) {
                    conf = builder2.define(ConfigBuilder.configName(configEntry, "String"), (Object)((String)field.get(object)));
                } else if (field.isAnnotationPresent(UnionConfig.Range.class)) {
                    UnionConfig.Range range = field.getAnnotation(UnionConfig.Range.class);
                    min = range.min();
                    max = range.max();
                    useSlider = range.useSlider();
                    conf = field.get(object) instanceof Integer ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Integer"), (Comparable)((Integer)field.get(object)), (Comparable)Integer.valueOf(min.intValue()), (Comparable)Integer.valueOf(max.intValue()), Integer.class) : (field.get(object) instanceof Float ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Float"), (Comparable)((Float)field.get(object)), (Comparable)Float.valueOf(min.floatValue()), (Comparable)Float.valueOf(max.floatValue()), Float.class) : (field.get(object) instanceof Long ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Long"), (Comparable)((Long)field.get(object)), (Comparable)Long.valueOf(min.longValue()), (Comparable)Long.valueOf(max.longValue()), Long.class) : (field.get(object) instanceof Short ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Short"), (Comparable)((Short)field.get(object)), (Comparable)Short.valueOf(min.shortValue()), (Comparable)Short.valueOf(max.shortValue()), Short.class) : (field.get(object) instanceof Byte ? builder2.defineInRange(ConfigBuilder.configName(configEntry, "Byte"), (Comparable)((Byte)field.get(object)), (Comparable)Byte.valueOf(min.byteValue()), (Comparable)Byte.valueOf(max.byteValue()), Byte.class) : builder2.defineInRange(ConfigBuilder.configName(configEntry, "Double"), (Comparable)((Double)field.get(object)), (Comparable)min, (Comparable)max, Double.class)))));
                } else {
                    conf = builder2.define(ConfigBuilder.configName(configEntry), field.get(object));
                }
                ConfigHolder<Object> holder = new ConfigHolder<Object>(conf, field.get(object), filename, saved_comment, useSlider, min, max);
                holders.add(holder);
                ConfigBuilder.putValue(type, config.name() + "=" + ConfigBuilder.configName(configEntry), holder);
                d.execute();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    static Map<String, ConfigHolder<?>> retrieveValues(ModConfig.Type ... types) {
        HashMap values = new HashMap();
        boolean hasClient = false;
        boolean hasCommon = false;
        boolean hasServer = false;
        for (ModConfig.Type type : types) {
            if (type == ModConfig.Type.CLIENT && !hasClient) {
                hasClient = true;
                values.putAll(client_values);
            }
            if (type == ModConfig.Type.COMMON && !hasCommon) {
                hasCommon = true;
                values.putAll(common_values);
            }
            if (type != ModConfig.Type.SERVER || hasServer) continue;
            hasServer = true;
            values.putAll(server_values);
        }
        return values;
    }

    static void putValue(ModConfig.Type type, String key, ConfigHolder<?> value) {
        if (type == ModConfig.Type.CLIENT) {
            client_values.put(key, value);
        }
        if (type == ModConfig.Type.COMMON) {
            common_values.put(key, value);
        }
        if (type == ModConfig.Type.SERVER) {
            server_values.put(key, value);
        }
    }

    public static String configName(UnionConfig.Entry configEntry, String dataType) {
        if (configEntry.group().isEmpty()) {
            if (!dataType.isEmpty()) {
                return dataType + ": " + configEntry.name();
            }
            return configEntry.name();
        }
        if (!dataType.isEmpty()) {
            return configEntry.group() + "." + dataType + ": " + configEntry.name();
        }
        return configEntry.group() + "." + configEntry.name();
    }

    public static String configName(UnionConfig.Entry configEntry) {
        return ConfigBuilder.configName(configEntry, "");
    }

    static ConfigHolder<?> getConfigValue(UnionConfig config, UnionConfig.Entry configEntry) {
        if (config != null && configEntry != null) {
            return ConfigBuilder.retrieveValues(ModConfig.Type.CLIENT, ModConfig.Type.COMMON, ModConfig.Type.SERVER).getOrDefault(config.name() + "=" + ConfigBuilder.configName(configEntry), new ConfigHolder<String>(new ForgeConfigSpec.Builder().define("empty", (Object)"nothing_was_found"), "nothing_was_found", "no_file", null, false, 0.0, 0.0));
        }
        return null;
    }

    public static Map<String, ConfigHolder<?>> getValues(UnionConfig config) {
        HashMap values2 = new HashMap();
        for (String configValue : ConfigBuilder.retrieveValues(ModConfig.Type.CLIENT, ModConfig.Type.COMMON, ModConfig.Type.SERVER).keySet()) {
            if (!configValue.split("=")[0].equals(config.name())) continue;
            values2.put(configValue, ConfigBuilder.retrieveValues(ModConfig.Type.CLIENT, ModConfig.Type.COMMON, ModConfig.Type.SERVER).get(configValue));
        }
        return values2;
    }

    public static void registerConfig(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class) && !ConfigClassBuilder.configs.containsKey(configClass)) {
            UnionConfig con = configClass.getAnnotation(UnionConfig.class);
            UnionLib.debug("Registered the config for " + con.name());
            ConfigClassBuilder.configs.put(configClass, Lists.newArrayList());
            ConfigClassBuilder.registerConfigurations(configClass);
            ConfigClassBuilder.loadConfigs(configClass);
        } else {
            if (!configClass.isAnnotationPresent(UnionConfig.class)) {
                throw new RuntimeException("You cannot register a config if it does not have the UnionConfig annotation");
            }
            if (ConfigClassBuilder.configs.containsKey(configClass)) {
                throw new RuntimeException("This config class has already been regtistered");
            }
        }
    }

    public static void registerConfig(ConfigObject configObject) {
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class) && !ConfigObjectBuilder.configs.containsKey(configObject)) {
            UnionConfig con = configObject.getClass().getAnnotation(UnionConfig.class);
            UnionLib.debug("Registered the config for " + con.name());
            ConfigObjectBuilder.configs.put(configObject, Lists.newArrayList());
            ConfigObjectBuilder.registerConfigurations(configObject);
            ConfigObjectBuilder.loadConfigs(configObject);
        } else {
            if (!configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
                throw new RuntimeException("You cannot register a config if it does not have the UnionConfig annotation");
            }
            if (ConfigObjectBuilder.configs.containsKey(configObject)) {
                throw new RuntimeException("This config object has already been regtistered");
            }
        }
    }

    public static void loadConfig(ForgeConfigSpec config, String path, String fileName) {
        File configFile = new File(path, fileName);
        configFile.getParentFile().mkdirs();
        UnionLib.debug(path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)configFile).sync().autosave().preserveInsertionOrder().onFileNotFound((newfile, configFormat) -> ConfigBuilder.setupConfigFile(configFile, newfile, configFormat)).writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    private static boolean setupConfigFile(File path, Path file, ConfigFormat<?> conf) throws IOException {
        Path p = Paths.get(path.getPath(), new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public static void reload(String name, ModConfig.Type ... exceptions) {
        UnionConfig con;
        for (Class<?> configClass : ConfigClassBuilder.configs.keySet()) {
            con = configClass.getAnnotation(UnionConfig.class);
            if (!con.autoReload() || !name.isEmpty() && !ConfigClassBuilder.configs.get(configClass).contains(name)) continue;
            ConfigBuilder.read(configClass, null, new ModConfig.Type[0]);
            UnionLib.debug("Found change in " + con.name() + "'s config file. Reloading values");
        }
        for (ConfigObject configObject : ConfigObjectBuilder.configs.keySet()) {
            con = configObject.getClass().getAnnotation(UnionConfig.class);
            if (!con.autoReload() || !name.isEmpty() && !ConfigObjectBuilder.configs.get(configObject).contains(name)) continue;
            ConfigBuilder.read(configObject.getClass(), configObject, new ModConfig.Type[0]);
            UnionLib.debug("Found change in " + con.name() + "'s config file. Reloading values");
        }
    }

    public static void reload(ModConfig.Type ... exceptions) {
        ConfigBuilder.reload("", exceptions);
    }

    public static void load(ModConfig.Type ... exceptions) {
        UnionConfig con;
        UnionLib.debug("Loading all values from the config files into their respective configuration variables");
        for (Class<?> configClass : ConfigClassBuilder.configs.keySet()) {
            con = configClass.getAnnotation(UnionConfig.class);
            ConfigBuilder.read(configClass, null, exceptions);
            UnionLib.debug("Loading " + con.name() + "'s config");
        }
        for (ConfigObject configObject : ConfigObjectBuilder.configs.keySet()) {
            con = configObject.getClass().getAnnotation(UnionConfig.class);
            ConfigBuilder.read(configObject.getClass(), configObject, exceptions);
            UnionLib.debug("Loading " + con.name() + "'s config");
        }
    }

    static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    protected static class Init {
        protected List<ConfigHolder<?>> holders = Lists.newArrayList();
        protected ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        protected String filename;

        protected Init(String name, UnionConfig con, String appendage) {
            this.filename = name + (String)(con.appendWithType() ? "-" + appendage : "") + ".toml";
        }

        protected ForgeConfigSpec create(Class<?> owner) {
            ForgeConfigSpec sp = this.builder.build();
            this.holders.forEach(hol -> hol.setSpec(owner, sp));
            return sp;
        }

        protected ForgeConfigSpec create(ConfigObject owner) {
            ForgeConfigSpec sp = this.builder.build();
            this.holders.forEach(hol -> hol.setSpec(owner, sp));
            return sp;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBus {
        @SubscribeEvent
        public static void onLoad(ModConfigEvent.Loading event) {
        }

        @SubscribeEvent
        public static void onReload(ModConfigEvent.Reloading event) {
            System.out.println(event.getConfig().getFileName());
            ConfigBuilder.reload(event.getConfig().getFileName(), new ModConfig.Type[0]);
        }
    }
}

