/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.config.ConfigClassBuilder;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.config.ConfigObjectBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHolder<T> {
    private Class<?> ownerClass;
    private ConfigObject ownerObject;
    private ForgeConfigSpec spec;
    private T cachedValue;
    protected final ForgeConfigSpec.ConfigValue<T> value;
    protected final T defaultValue;
    protected final String parentFile;
    protected final List<Component> comments;
    protected final boolean usesSlider;
    protected final double min;
    protected final double max;

    public ConfigHolder(ForgeConfigSpec.ConfigValue<T> configvalue, T defaultValue, String parentFile, List<Component> comments, boolean usesSlider, double min, double max) {
        this.comments = comments;
        this.value = configvalue;
        this.parentFile = parentFile;
        this.defaultValue = defaultValue;
        this.usesSlider = usesSlider;
        this.min = min;
        this.max = max;
    }

    public void setSpec(Class<?> owner, ForgeConfigSpec spec) {
        this.ownerClass = owner;
        this.spec = spec;
    }

    public void setSpec(ConfigObject owner, ForgeConfigSpec spec) {
        this.ownerObject = owner;
        this.spec = spec;
    }

    public T get() {
        if (this.spec.isLoaded()) {
            this.cachedValue = this.value.get();
        } else {
            UnionLib.debug("Spec not loaded, rebuilding config");
            if (this.ownerClass != null) {
                ConfigClassBuilder.loadConfigs(this.ownerClass);
            }
            if (this.ownerObject != null) {
                ConfigObjectBuilder.loadConfigs(this.ownerObject);
            }
        }
        if (this.cachedValue == null) {
            UnionLib.debug("Cached value is null, returning default");
            return this.defaultValue;
        }
        return this.cachedValue;
    }

    public void set(T newValue) {
        this.value.set(newValue);
        this.cachedValue = newValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getParentFile() {
        return this.parentFile;
    }

    public List<Component> getComments() {
        return this.comments;
    }

    public boolean isUsingSlider() {
        return this.usesSlider;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

