/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.hook;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.stereowalker.unionlib.event.item.ItemAttributeEvent;
import com.stereowalker.unionlib.event.item.ItemCraftedEvent;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.world.entity.ai.UAttributes;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class NeedleHooks {
    public static void firePlayerCraftingEvent(CraftingContainer craftMatrix, ResultSlot slot, Player player, ItemStack crafted) {
        MinecraftForge.EVENT_BUS.post((Event)new ItemCraftedEvent(player, crafted, (Container)craftMatrix, slot));
    }

    public static Multimap<Attribute, AttributeModifier> adjustAttributeMap(Multimap<Attribute, AttributeModifier> original, EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap modifiedMap = HashMultimap.create(original);
        ItemAttributeEvent event = new ItemAttributeEvent((HashMultimap<Attribute, AttributeModifier>)modifiedMap, equipmentSlot, stack);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            builder.putAll((Multimap)modifiedMap);
        }
        return builder.build();
    }

    public static float calculateSpeed(LivingEntity l) {
        double speed = 1.0;
        if (ModHandler.getLoadState().runsOnBothSides() && l.m_21051_(UAttributes.DRAW_SPEED) != null) {
            speed = l.m_21133_(UAttributes.DRAW_SPEED);
        }
        return (float)(1.0 / speed * 20.0);
    }

    public static float getBowPowerForTime(int pCharge, Player player) {
        float f = (float)pCharge / NeedleHooks.calculateSpeed((LivingEntity)player);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

