/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mixin;

import com.stereowalker.unionlib.world.entity.ai.UAttributes;
import com.stereowalker.unionlib.world.entity.player.CustomInventoryGetter;
import com.stereowalker.unionlib.world.entity.player.UnionInventory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements CustomInventoryGetter {
    private UnionInventory uInv = new UnionInventory((Player)this);

    private PlayerMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public UnionInventory getUnionInventory() {
        return this.uInv;
    }

    @Override
    public void setUnionInventory(UnionInventory inv) {
        this.uInv = inv;
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    public void aiStep_inject(CallbackInfo ci) {
        this.getUnionInventory().tick();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.m_128365_("UnionInventory", (Tag)this.uInv.save(new ListTag()));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        ListTag listtag = pCompound.m_128437_("UnionInventory", 10);
        this.uInv.load(listtag);
    }

    @Inject(method={"dropEquipment"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;dropAll()V")})
    public void dropEquipment_inject(CallbackInfo ci) {
        this.uInv.dropAll();
    }

    @Inject(method={"destroyVanishingCursedItems"}, at={@At(value="TAIL")})
    public void destroyVanishingCursedItems_inject(CallbackInfo ci) {
        for (int i = 0; i < this.uInv.m_6643_(); ++i) {
            ItemStack itemstack = this.uInv.m_8020_(i);
            if (itemstack.m_41619_() || !EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.uInv.m_8016_(i);
        }
    }

    @ModifyVariable(method={"getDigSpeed(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)F"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectUtil;hasDigSpeed(Lnet/minecraft/world/entity/LivingEntity;)Z"), index=3)
    private float getDigSpeed(float f) {
        AttributeInstance instance = this.m_21051_(UAttributes.DIG_SPEED);
        if (instance != null) {
            for (AttributeModifier modifier : instance.m_22122_()) {
                float amount = (float)modifier.m_22218_();
                if (modifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                    f += amount;
                    continue;
                }
                f *= amount + 1.0f;
            }
        }
        return f;
    }
}

